/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.request;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.uri.URIUtil;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="getQueryParams", receiver=@Receiver(type=TypeKind.STRUCT, structType="Request", structPackage="ballerina.http"), returnType={@ReturnType(type=TypeKind.MAP, elementType=TypeKind.STRING)}, isPublic=true)
public class GetQueryParams
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            BStruct requestStruct = (BStruct)context.getRefArgument(0);
            HTTPCarbonMessage httpCarbonMessage = (HTTPCarbonMessage)requestStruct.getNativeData("transport_message");
            BMapType mapType = new BMapType(BTypes.typeString);
            if (httpCarbonMessage.getProperty("QUERY_STR") != null) {
                String queryString = (String)httpCarbonMessage.getProperty("QUERY_STR");
                BMap params = new BMap(mapType);
                URIUtil.populateQueryParamMap(queryString, (BMap<String, BString>)params);
                context.setReturnValues(new BValue[]{params});
            } else {
                context.setReturnValues(new BValue[]{new BMap(mapType)});
            }
        }
        catch (Throwable e) {
            throw new BallerinaException("Error while retrieving query param from message: " + e.getMessage());
        }
    }
}

