/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.session;

import java.util.NoSuchElementException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.session.Session;
import org.ballerinalang.net.http.session.SessionManager;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="getSession", receiver=@Receiver(type=TypeKind.STRUCT, structType="Request", structPackage="ballerina.http"), returnType={@ReturnType(type=TypeKind.STRUCT, structType="Session", structPackage="ballerina.http")}, isPublic=true)
public class GetSession
extends BlockingNativeCallableUnit {
    private static final Logger logger = LoggerFactory.getLogger(GetSession.class);

    public void execute(Context context) {
        try {
            BStruct requestStruct = (BStruct)context.getRefArgument(0);
            HTTPCarbonMessage httpCarbonMessage = HttpUtil.getCarbonMsg(requestStruct, null);
            String cookieHeader = httpCarbonMessage.getHeader("Cookie");
            String path = (String)httpCarbonMessage.getProperty("BASE_PATH");
            Session session = (Session)httpCarbonMessage.getProperty("http_session");
            if (cookieHeader != null) {
                try {
                    String sessionId = HttpUtil.getSessionID(cookieHeader);
                    if (session != null && sessionId.equals(session.getId())) {
                        session = session.setAccessed();
                        context.setReturnValues(new BValue[]{HttpUtil.createSessionStruct(context, session)});
                        return;
                    }
                    session = SessionManager.getInstance().getHTTPSession(sessionId);
                }
                catch (NoSuchElementException e) {
                    logger.info("Failed to get session: Incorrect Session cookie");
                }
                if (session == null) {
                    logger.info("Failed to get session: session is not available");
                    context.setReturnValues(new BValue[0]);
                    return;
                }
                if (session == null || !session.getPath().equals(path)) {
                    throw new BallerinaException("Failed to get session: " + path + " is not an allowed path");
                }
            } else {
                logger.info("Failed to get session: session cookie is not available");
                context.setReturnValues(new BValue[0]);
                return;
            }
            session.setNew(false);
            session.setAccessed();
            httpCarbonMessage.setProperty("http_session", (Object)session);
            httpCarbonMessage.removeHeader("Cookie");
            context.setReturnValues(new BValue[]{HttpUtil.createSessionStruct(context, session)});
        }
        catch (IllegalStateException e) {
            throw new BallerinaException(e.getMessage(), (Throwable)e);
        }
    }
}

