/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.serviceendpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpConnectionManager;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfig;
import org.wso2.transport.http.netty.contract.ServerConnector;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="initEndpoint", receiver=@Receiver(type=TypeKind.STRUCT, structType="Listener", structPackage="ballerina.http"), isPublic=true)
public class InitEndpoint
extends BlockingNativeCallableUnit {
    private static final ConfigRegistry configRegistry = ConfigRegistry.getInstance();

    public void execute(Context context) {
        try {
            Struct serviceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
            Struct serviceEndpointConfig = serviceEndpoint.getStructField("config");
            ListenerConfiguration listenerConfiguration = this.getListenerConfig(serviceEndpointConfig);
            ServerConnector httpServerConnector = HttpConnectionManager.getInstance().createHttpServerConnector(listenerConfiguration);
            serviceEndpoint.addNativeData("HTTP_SERVER_CONNECTOR", (Object)httpServerConnector);
            WebSocketServicesRegistry webSocketServicesRegistry = new WebSocketServicesRegistry();
            HTTPServicesRegistry httpServicesRegistry = new HTTPServicesRegistry(webSocketServicesRegistry);
            serviceEndpoint.addNativeData("HTTP_SERVICE_REGISTRY", (Object)httpServicesRegistry);
            serviceEndpoint.addNativeData("WS_SERVICE_REGISTRY", (Object)webSocketServicesRegistry);
            this.setFilters(serviceEndpointConfig, serviceEndpoint);
            context.setReturnValues(new BValue[]{null});
        }
        catch (Throwable throwable) {
            BStruct errorStruct = HttpUtil.getHttpConnectorError(context, throwable);
            context.setReturnValues(new BValue[]{errorStruct});
        }
    }

    private void setFilters(Struct endpointConfig, Struct serviceEndpoint) {
        Value[] filterValues = endpointConfig.getArrayField("filters");
        if (filterValues == null) {
            return;
        }
        serviceEndpoint.addNativeData("FILTERS", (Object)filterValues);
    }

    private ListenerConfiguration getListenerConfig(Struct endpointConfig) {
        String host = endpointConfig.getStringField("host");
        long port = endpointConfig.getIntField("port");
        String keepAlive = endpointConfig.getRefField("keepAlive").getStringValue();
        String transferEncoding = endpointConfig.getRefField("transferEncoding").getStringValue();
        Struct sslConfig = endpointConfig.getStructField("secureSocket");
        String httpVersion = endpointConfig.getStringField("httpVersion");
        Struct requestLimits = endpointConfig.getStructField("requestLimits");
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        if (host == null || host.trim().isEmpty()) {
            listenerConfiguration.setHost(configRegistry.getConfigOrDefault("b7a.http.host", "0.0.0.0"));
        } else {
            listenerConfiguration.setHost(host);
        }
        if (port == 0L) {
            throw new BallerinaConnectorException("Listener port is not defined!");
        }
        listenerConfiguration.setPort(Math.toIntExact(port));
        listenerConfiguration.setKeepAliveConfig(HttpUtil.getKeepAliveConfig(keepAlive));
        if (!transferEncoding.isEmpty() && !"chunking".equalsIgnoreCase(transferEncoding)) {
            throw new BallerinaConnectorException("Unsupported configuration found for Transfer-Encoding : " + transferEncoding);
        }
        if (requestLimits != null) {
            this.setRequestSizeValidationConfig(requestLimits, listenerConfiguration);
        }
        if (httpVersion != null) {
            listenerConfiguration.setVersion(httpVersion);
        }
        if (sslConfig != null) {
            return this.setSslConfig(sslConfig, listenerConfiguration);
        }
        listenerConfiguration.setServerHeader(this.getServerName());
        return listenerConfiguration;
    }

    private void setRequestSizeValidationConfig(Struct requestLimits, ListenerConfiguration listenerConfiguration) {
        long maxUriLength = requestLimits.getIntField("maxUriLength");
        long maxHeaderSize = requestLimits.getIntField("maxHeaderSize");
        long maxEntityBodySize = requestLimits.getIntField("maxEntityBodySize");
        RequestSizeValidationConfig requestSizeValidationConfig = listenerConfiguration.getRequestSizeValidationConfig();
        if (maxUriLength != -1L) {
            if (maxUriLength >= 0L) {
                requestSizeValidationConfig.setMaxUriLength(Math.toIntExact(maxUriLength));
            } else {
                throw new BallerinaConnectorException("Invalid configuration found for maxUriLength : " + maxUriLength);
            }
        }
        if (maxHeaderSize != -1L) {
            if (maxHeaderSize >= 0L) {
                requestSizeValidationConfig.setMaxHeaderSize(Math.toIntExact(maxHeaderSize));
            } else {
                throw new BallerinaConnectorException("Invalid configuration found for maxHeaderSize : " + maxHeaderSize);
            }
        }
        if (maxEntityBodySize != -1L) {
            if (maxEntityBodySize >= 0L) {
                requestSizeValidationConfig.setMaxEntityBodySize(Math.toIntExact(maxEntityBodySize));
            } else {
                throw new BallerinaConnectorException("Invalid configuration found for maxEntityBodySize : " + maxEntityBodySize);
            }
        }
    }

    private String getServerName() {
        String version = System.getProperty("ballerina.version");
        String userAgent = version != null ? "ballerina/" + version : "ballerina";
        return userAgent;
    }

    private ListenerConfiguration setSslConfig(Struct sslConfig, ListenerConfiguration listenerConfiguration) {
        long cacheValidationPeriod;
        long cacheSize;
        List<Value> ciphersValueList;
        Parameter serverParameters;
        listenerConfiguration.setScheme("https");
        Struct trustStore = sslConfig.getStructField("trustStore");
        Struct keyStore = sslConfig.getStructField("keyStore");
        Struct protocols = sslConfig.getStructField("protocol");
        Struct validateCert = sslConfig.getStructField("certValidation");
        Struct ocspStapling = sslConfig.getStructField("ocspStapling");
        if (keyStore != null) {
            String keyStoreFile = keyStore.getStringField("path");
            String keyStorePassword = keyStore.getStringField("password");
            if (StringUtils.isBlank((CharSequence)keyStoreFile)) {
                throw new BallerinaConnectorException("Keystore location must be provided for secure connection");
            }
            if (StringUtils.isBlank((CharSequence)keyStorePassword)) {
                throw new BallerinaConnectorException("Keystore password value must be provided for secure connection");
            }
            listenerConfiguration.setKeyStoreFile(keyStoreFile);
            listenerConfiguration.setKeyStorePass(keyStorePassword);
        }
        String sslVerifyClient = sslConfig.getStringField("sslVerifyClient");
        listenerConfiguration.setVerifyClient(sslVerifyClient);
        if (trustStore != null) {
            String trustStoreFile = trustStore.getStringField("path");
            String trustStorePassword = trustStore.getStringField("password");
            if (StringUtils.isBlank((CharSequence)trustStoreFile) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw new BallerinaException("Truststore location must be provided to enable Mutual SSL");
            }
            if (StringUtils.isBlank((CharSequence)trustStorePassword) && StringUtils.isNotBlank((CharSequence)sslVerifyClient)) {
                throw new BallerinaException("Truststore password value must be provided to enable Mutual SSL");
            }
            listenerConfiguration.setTrustStoreFile(trustStoreFile);
            listenerConfiguration.setTrustStorePass(trustStorePassword);
        }
        ArrayList<Parameter> serverParamList = new ArrayList<Parameter>();
        if (protocols != null) {
            String sslProtocol;
            List<Value> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayField("versions"));
            if (sslEnabledProtocolsValueList.size() > 0) {
                String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
                serverParameters = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                serverParamList.add(serverParameters);
            }
            if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringField("name")))) {
                listenerConfiguration.setSSLProtocol(sslProtocol);
            }
        }
        if ((ciphersValueList = Arrays.asList(sslConfig.getArrayField("ciphers"))).size() > 0) {
            String ciphers = ciphersValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
            serverParameters = new Parameter("ciphers", ciphers);
            serverParamList.add(serverParameters);
        }
        if (validateCert != null) {
            boolean validateCertificateEnabled = validateCert.getBooleanField("enable");
            cacheSize = validateCert.getIntField("cacheSize");
            cacheValidationPeriod = validateCert.getIntField("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(validateCertificateEnabled);
            if (validateCertificateEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        if (ocspStapling != null) {
            boolean ocspStaplingEnabled = ocspStapling.getBooleanField("enable");
            listenerConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            cacheSize = ocspStapling.getIntField("cacheSize");
            cacheValidationPeriod = ocspStapling.getIntField("cacheValidityPeriod");
            listenerConfiguration.setValidateCertEnabled(ocspStaplingEnabled);
            if (ocspStaplingEnabled) {
                if (cacheSize != 0L) {
                    listenerConfiguration.setCacheSize(Math.toIntExact(cacheSize));
                }
                if (cacheValidationPeriod != 0L) {
                    listenerConfiguration.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
                }
            }
        }
        listenerConfiguration.setTLSStoreType("PKCS12");
        String serverEnableSessionCreation = String.valueOf(sslConfig.getBooleanField("shareSession"));
        Parameter enableSessionCreationParam = new Parameter("shareSession", serverEnableSessionCreation);
        serverParamList.add(enableSessionCreationParam);
        if (!serverParamList.isEmpty()) {
            listenerConfiguration.setParameters(serverParamList);
        }
        listenerConfiguration.setId(HttpUtil.getListenerInterface(listenerConfiguration.getHost(), listenerConfiguration.getPort()));
        return listenerConfiguration;
    }
}

