/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.serviceendpoint;

import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.BallerinaHTTPConnectorListener;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpConnectorPortBindingListener;
import org.ballerinalang.net.http.WebSocketServerConnectorListener;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketServicesRegistry;
import org.ballerinalang.net.http.serviceendpoint.AbstractHttpNativeFunction;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="register", receiver=@Receiver(type=TypeKind.STRUCT, structType="Listener", structPackage="ballerina.http"), args={@Argument(name="serviceType", type=TypeKind.TYPEDESC)}, isPublic=true)
public class Register
extends AbstractHttpNativeFunction {
    public void execute(Context context) {
        Service service = BLangConnectorSPIUtil.getServiceRegistered((Context)context);
        Struct serviceEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
        HTTPServicesRegistry httpServicesRegistry = this.getHttpServicesRegistry(serviceEndpoint);
        WebSocketServicesRegistry webSocketServicesRegistry = this.getWebSocketServicesRegistry(serviceEndpoint);
        if ("ballerina.http:Listener".equals(service.getEndpointName())) {
            httpServicesRegistry.registerService(service);
        }
        if ("ballerina.http:WebSocketListener".equals(service.getEndpointName())) {
            WebSocketService webSocketService = new WebSocketService(service);
            webSocketServicesRegistry.registerService(webSocketService);
        }
        if (!this.isConnectorStarted(serviceEndpoint)) {
            this.startServerConnector(serviceEndpoint, httpServicesRegistry, webSocketServicesRegistry);
        }
        context.setReturnValues(new BValue[0]);
    }

    private void startServerConnector(Struct serviceEndpoint, HTTPServicesRegistry httpServicesRegistry, WebSocketServicesRegistry webSocketServicesRegistry) {
        ServerConnector serverConnector = this.getServerConnector(serviceEndpoint);
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        Value[] filterHolder = this.getFilters(serviceEndpoint);
        serverConnectorFuture.setHttpConnectorListener((HttpConnectorListener)new BallerinaHTTPConnectorListener(httpServicesRegistry, filterHolder));
        serverConnectorFuture.setWSConnectorListener((WebSocketConnectorListener)new WebSocketServerConnectorListener(webSocketServicesRegistry));
        serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)new HttpConnectorPortBindingListener());
        try {
            serverConnectorFuture.sync();
        }
        catch (Throwable ex) {
            throw new BallerinaException("failed to start server connector '" + serverConnector.getConnectorID() + "': " + ex.getMessage(), ex);
        }
        serviceEndpoint.addNativeData("CONNECTOR_STARTED", (Object)true);
    }
}

