/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.session;

import java.io.Serializable;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.http.session.Session;
import org.ballerinalang.net.http.session.SessionManager;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HTTPSession
implements Session,
Serializable {
    private final String sessionPath;
    private String id;
    private Long createTime;
    private Long accessedTime;
    private Long lastAccessedTime;
    private int maxInactiveInterval;
    private BMap<String, BValue> attributeMap = new BMap();
    private SessionManager sessionManager;
    private boolean isValid = true;
    private boolean isNew = true;

    public HTTPSession(String id, int maxInactiveInterval, String path) {
        this.id = id;
        this.maxInactiveInterval = maxInactiveInterval;
        this.lastAccessedTime = this.accessedTime = (this.createTime = Long.valueOf(System.currentTimeMillis()));
        this.sessionPath = path;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setAttribute(String attributeKey, BValue attributeValue) {
        this.attributeMap.put((Object)attributeKey, attributeValue);
    }

    @Override
    public BValue getAttributeValue(String attributeKey) {
        return this.attributeMap.get((Object)attributeKey);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributeMap.keySet().toArray(new String[this.attributeMap.size()]);
    }

    @Override
    public BMap<String, BValue> getAttributes() {
        return this.attributeMap;
    }

    @Override
    public Session setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    @Override
    public String getPath() {
        return this.sessionPath;
    }

    @Override
    public void removeAttribute(String name) {
        this.attributeMap.remove((Object)name);
    }

    @Override
    public Long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public Long getCreationTime() {
        return this.createTime;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Override
    public void invalidate() {
        this.sessionManager.invalidateSession(this);
        this.attributeMap = new BMap();
        this.isValid = false;
    }

    @Override
    public Session setAccessed() {
        this.checkValidity();
        this.lastAccessedTime = this.accessedTime;
        this.accessedTime = System.currentTimeMillis();
        return this;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void generateSessionHeader(HTTPCarbonMessage message, boolean isSecureRequest) {
        if (this.isNew()) {
            message.setHeader("Set-Cookie", "BSESSIONID=" + this.getId() + "; " + "Path=" + this.getPath() + ";" + (isSecureRequest ? " Secure;" : "") + " " + "HttpOnly" + ";");
        }
    }

    public void setManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private void checkValidity() {
        if (!this.isValid) {
            throw new IllegalStateException("Failed to execute action: Invalid session");
        }
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }
}

