/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.session;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(SessionIdGenerator.class);
    private int sessionIdLength = 16;
    private final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();
    private String secureRandomClass = null;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private String secureRandomProvider = null;

    public void setSessionIdLength(int sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public String generateSessionId() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder(2 * this.sessionIdLength + 20);
        int resultLenBytes = 0;
        while (resultLenBytes < this.sessionIdLength) {
            this.getRandomBytes(random);
            for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                byte b1 = (byte)((random[j] & 0xF0) >> 4);
                byte b2 = (byte)(random[j] & 0xF);
                if (b1 < 10) {
                    buffer.append((char)(48 + b1));
                } else {
                    buffer.append((char)(65 + (b1 - 10)));
                }
                if (b2 < 10) {
                    buffer.append((char)(48 + b2));
                    continue;
                }
                buffer.append((char)(65 + (b2 - 10)));
            }
        }
        return buffer.toString();
    }

    protected void getRandomBytes(byte[] bytes) {
        SecureRandom random = this.randoms.poll();
        if (random == null) {
            random = this.createSecureRandom();
        }
        random.nextBytes(bytes);
        this.randoms.add(random);
    }

    private SecureRandom createSecureRandom() {
        SecureRandom result = null;
        long t1 = System.currentTimeMillis();
        if (this.secureRandomClass != null) {
            try {
                Class<?> clazz = Class.forName(this.secureRandomClass);
                result = (SecureRandom)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("Cannot load secureRandomClass: " + this.secureRandomClass, (Throwable)e);
            }
        }
        if (result == null) {
            try {
                if (this.secureRandomProvider != null && this.secureRandomProvider.length() > 0) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm, this.secureRandomProvider);
                } else if (this.secureRandomAlgorithm != null && this.secureRandomAlgorithm.length() > 0) {
                    result = SecureRandom.getInstance(this.secureRandomAlgorithm);
                }
            }
            catch (NoSuchAlgorithmException e) {
                log.error("SecureRandomAlgorithm " + this.secureRandomAlgorithm + " not found", (Throwable)e);
            }
            catch (NoSuchProviderException e) {
                log.error("SecureRandomProvider not found " + this.secureRandomProvider, (Throwable)e);
            }
        }
        if (result == null) {
            try {
                result = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                log.error("SecureRandomAlgorithm " + this.secureRandomAlgorithm + " not found", (Throwable)e);
            }
        }
        if (result == null) {
            result = new SecureRandom();
        }
        result.nextInt();
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 100L) {
            log.warn("Session took more than 100ms to create! Time taken: " + (t2 - t1) + "ms");
        }
        return result;
    }
}

