/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.net.http.session.HTTPSession;
import org.ballerinalang.net.http.session.Session;
import org.ballerinalang.net.http.session.SessionIdGenerator;

public class SessionManager {
    private static SessionManager instance = new SessionManager();
    private Map<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();
    private SessionIdGenerator sessionIdGenerator = new SessionIdGenerator();
    private ScheduledExecutorService sessionExpiryChecker;
    private static final int DEFAULT_MAX_ACTIVE_SESSIONS = 100000;
    private static final int DEFAULT_MAX_INACTIVE_INTERVAL = 900;
    private static final int SESSION_ID_LENGTH = 16;

    private SessionManager() {
        this.sessionIdGenerator.setSessionIdLength(16);
        this.sessionExpiryChecker = Executors.newScheduledThreadPool(1);
        this.sessionExpiryChecker.scheduleAtFixedRate(() -> this.sessionMap.values().parallelStream().filter(session -> session.getMaxInactiveInterval() >= 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000)).forEach(Session::invalidate), 30L, 30L, TimeUnit.SECONDS);
    }

    public static SessionManager getInstance() {
        return instance;
    }

    public Session getHTTPSession(String sessionId) {
        HTTPSession session = (HTTPSession)this.sessionMap.get(sessionId);
        if (session != null) {
            return session;
        }
        return null;
    }

    public Session createHTTPSession(String path) {
        if (this.sessionMap.size() >= 100000) {
            throw new IllegalStateException("Failed to create session: Too many active sessions");
        }
        HTTPSession session = new HTTPSession(this.sessionIdGenerator.generateSessionId(), 900, path);
        session.setManager(this);
        this.sessionMap.put(session.getId(), session);
        return session;
    }

    public void invalidateSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    public void stop() {
        this.sessionExpiryChecker.shutdown();
    }
}

