/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocketclientendpoint;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.util.codegen.ProgramFile;
import org.wso2.transport.http.netty.contract.websocket.WsClientConnectorConfig;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="initEndpoint", receiver=@Receiver(type=TypeKind.STRUCT, structType="WebSocketClient", structPackage="ballerina.http"), args={@Argument(name="epName", type=TypeKind.STRING), @Argument(name="config", type=TypeKind.STRUCT, structType="ServiceEndpointConfiguration")}, isPublic=true)
public class InitEndpoint
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        WsClientConnectorConfig clientConnectorConfig;
        WebSocketService wsService;
        Struct clientEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
        Struct clientEndpointConfig = clientEndpoint.getStructField("config");
        String remoteUrl = clientEndpointConfig.getStringField("url");
        Value clientServiceType = clientEndpointConfig.getTypeField("callbackService");
        Service service = BLangConnectorSPIUtil.getServiceFromType((ProgramFile)context.getProgramFile(), (Value)clientServiceType);
        if (service == null) {
            throw new BallerinaConnectorException("Cannot find client service: " + clientServiceType);
        }
        if ("ballerina.http:WebSocketClient".equals(service.getEndpointName())) {
            long idleTimeoutInSeconds;
            Map headerValues;
            wsService = new WebSocketService(service);
            clientConnectorConfig = new WsClientConnectorConfig(remoteUrl);
            clientConnectorConfig.setAutoRead(false);
            Value[] subProtocolValues = clientEndpointConfig.getArrayField("subProtocols");
            if (subProtocolValues != null) {
                clientConnectorConfig.setSubProtocols((String[])Arrays.stream(subProtocolValues).map(Value::getStringValue).toArray(String[]::new));
            }
            if ((headerValues = clientEndpointConfig.getMapField("customHeaders")) != null) {
                clientConnectorConfig.addHeaders(this.getCustomHeaders(headerValues));
            }
            if ((idleTimeoutInSeconds = clientEndpointConfig.getIntField("idleTimeoutInSeconds")) > 0L) {
                clientConnectorConfig.setIdleTimeoutInMillis((int)(idleTimeoutInSeconds * 1000L));
            }
        } else {
            throw new BallerinaConnectorException("Incorrect endpoint: " + service.getEndpointName());
        }
        clientEndpointConfig.addNativeData("callbackService", (Object)wsService);
        clientEndpointConfig.addNativeData("clientEndpointConfigs", (Object)clientConnectorConfig);
        context.setReturnValues(new BValue[0]);
    }

    Map<String, String> getCustomHeaders(Map<String, Value> headers) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        headers.keySet().forEach(key -> customHeaders.put((String)key, ((Value)headers.get(key)).getStringValue()));
        return customHeaders;
    }
}

