/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocketclientendpoint;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.WebSocketClientConnectorListener;
import org.ballerinalang.net.http.WebSocketOpenConnectionInfo;
import org.ballerinalang.net.http.WebSocketService;
import org.ballerinalang.net.http.WebSocketUtil;
import org.ballerinalang.util.codegen.ProgramFile;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.websocket.HandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.HandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WsClientConnectorConfig;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="start", receiver=@Receiver(type=TypeKind.STRUCT, structType="WebSocketClient", structPackage="ballerina.http"), isPublic=true)
public class Start
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        HttpWsConnectorFactory connectorFactory = HttpUtil.createHttpWsConnectionFactory();
        Struct clientEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
        Struct clientEndpointConfig = clientEndpoint.getStructField("config");
        Object configs = clientEndpointConfig.getNativeData("clientEndpointConfigs");
        if (configs == null || !(configs instanceof WsClientConnectorConfig)) {
            throw new BallerinaConnectorException("Error in initializing: Missing client endpoint configurations");
        }
        WebSocketClientConnector clientConnector = connectorFactory.createWsClientConnector((WsClientConnectorConfig)configs);
        WebSocketClientConnectorListener clientConnectorListener = new WebSocketClientConnectorListener();
        Object serviceConfig = clientEndpointConfig.getNativeData("callbackService");
        if (serviceConfig == null || !(serviceConfig instanceof WebSocketService)) {
            throw new BallerinaConnectorException("Error in initializing: A callbackService is required");
        }
        WebSocketService wsService = (WebSocketService)serviceConfig;
        boolean readyOnConnect = clientEndpointConfig.getBooleanField("readyOnConnect");
        HandshakeFuture handshakeFuture = clientConnector.connect((WebSocketConnectorListener)clientConnectorListener);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        handshakeFuture.setHandshakeListener((HandshakeListener)new WsHandshakeListener(context, wsService, clientConnectorListener, readyOnConnect, countDownLatch));
        try {
            if (!countDownLatch.await(60L, TimeUnit.SECONDS)) {
                throw new BallerinaConnectorException("Waiting for WebSocket handshake in not successful");
            }
        }
        catch (InterruptedException e) {
            throw new BallerinaConnectorException("Error occurred: " + e.getMessage());
        }
    }

    static class WsHandshakeListener
    implements HandshakeListener {
        private final Context context;
        private final WebSocketService wsService;
        private final WebSocketClientConnectorListener clientConnectorListener;
        private final boolean readyOnConnect;
        CountDownLatch countDownLatch;

        WsHandshakeListener(Context context, WebSocketService wsService, WebSocketClientConnectorListener clientConnectorListener, boolean readyOnConnect, CountDownLatch countDownLatch) {
            this.context = context;
            this.wsService = wsService;
            this.clientConnectorListener = clientConnectorListener;
            this.readyOnConnect = readyOnConnect;
            this.countDownLatch = countDownLatch;
        }

        public void onSuccess(WebSocketConnection webSocketConnection) {
            BStruct webSocketClientEndpoint = (BStruct)this.context.getRefArgument(0);
            BStruct webSocketConnector = BLangConnectorSPIUtil.createObject((ProgramFile)this.wsService.getResources()[0].getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile(), (String)"ballerina.http", (String)"WebSocketConnector", (BValue[])new BValue[0]);
            webSocketConnector.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION", (Object)webSocketConnection);
            WebSocketUtil.populateEndpoint(webSocketConnection, webSocketClientEndpoint);
            WebSocketOpenConnectionInfo connectionInfo = new WebSocketOpenConnectionInfo(this.wsService, webSocketClientEndpoint);
            this.clientConnectorListener.setConnectionInfo(connectionInfo);
            webSocketClientEndpoint.setRefField(1, (BRefType)webSocketConnector);
            this.context.setReturnValues(new BValue[0]);
            if (this.readyOnConnect) {
                webSocketConnection.readNextFrame();
            }
            this.countDownLatch.countDown();
        }

        public void onError(Throwable t) {
            this.countDownLatch.countDown();
            throw new BallerinaConnectorException("Error occurred: " + t.getMessage());
        }
    }
}

