/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class URIUtil {
    public static final String URI_PATH_DELIMITER = "/";

    public static String[] getPathSegments(String path) {
        if (path.startsWith(URI_PATH_DELIMITER)) {
            path = path.substring(1);
        }
        return path.split(URI_PATH_DELIMITER);
    }

    public static String getSubPath(String path, String basePath) {
        if (path.length() == basePath.length()) {
            return URI_PATH_DELIMITER;
        }
        return path.substring(basePath.length());
    }

    public static void populateQueryParamMap(String queryParamString, BMap<String, BString> queryParamsMap) throws UnsupportedEncodingException {
        String[] queryParamVals;
        for (String queryParam : queryParamVals = queryParamString.split("&")) {
            int index = queryParam.indexOf(61);
            if (index == -1) continue;
            String queryParamName = queryParam.substring(0, index).trim();
            String queryParamValue = URLDecoder.decode(queryParam.substring(index + 1).trim(), "UTF-8");
            if (queryParamValue.matches("")) {
                queryParamsMap.put((Object)queryParamName, (BValue)new BString(""));
                continue;
            }
            queryParamsMap.put((Object)queryParamName, (BValue)new BString(queryParamValue));
        }
    }

    public static BMap<String, BValue> getMatrixParamsMap(String path, HTTPCarbonMessage carbonMessage) {
        BMap matrixParamsBMap = new BMap();
        Map pathToMatrixParamMap = (Map)carbonMessage.getProperty("MATRIX_PARAMS");
        Map matrixParamsMap = (Map)pathToMatrixParamMap.get(path);
        if (matrixParamsMap != null) {
            for (Map.Entry matrixParamEntry : matrixParamsMap.entrySet()) {
                matrixParamsBMap.put(matrixParamEntry.getKey(), (BValue)new BString((String)matrixParamEntry.getValue()));
            }
        }
        return matrixParamsBMap;
    }

    public static String extractMatrixParams(String path, Map<String, Map<String, String>> matrixParams) {
        if (path.startsWith(URI_PATH_DELIMITER)) {
            path = path.substring(1);
        }
        String[] pathSplits = path.split("\\?");
        String[] pathSegments = pathSplits[0].split(URI_PATH_DELIMITER);
        String pathToMatrixParam = "";
        for (String pathSegment : pathSegments) {
            String[] splitPathSegment = pathSegment.split(";");
            pathToMatrixParam = pathToMatrixParam.concat(URI_PATH_DELIMITER + splitPathSegment[0]);
            HashMap<String, String> segmentMatrixParams = new HashMap<String, String>();
            for (int i = 1; i < splitPathSegment.length; ++i) {
                String[] splitMatrixParam = splitPathSegment[i].split("=");
                if (splitMatrixParam.length != 2) {
                    throw new BallerinaConnectorException(String.format("Found non-matrix parameter '%s' in path '%s'", splitPathSegment[i], path));
                }
                segmentMatrixParams.put(splitMatrixParam[0], splitMatrixParam[1]);
            }
            matrixParams.put(pathToMatrixParam, segmentMatrixParams);
        }
        for (int i = 1; i < pathSplits.length; ++i) {
            pathToMatrixParam = pathToMatrixParam.concat("?").concat(pathSplits[i]);
        }
        return pathToMatrixParam;
    }
}

