/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri.nativeimpl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.http.HttpUtil;

@BallerinaFunction(orgName="ballerina", packageName="http", functionName="encode", args={@Argument(name="url", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING), @ReturnType(type=TypeKind.STRUCT, structType="Error")}, isPublic=true)
public class Encode
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String url = context.getStringArgument(0);
        String charset = context.getStringArgument(1);
        try {
            context.setReturnValues(new BValue[]{new BString(this.encode(url, charset))});
        }
        catch (Throwable e) {
            context.setReturnValues(new BValue[]{HttpUtil.getGenericError(context, "Error occurred while encoding the url. " + e.getMessage())});
        }
    }

    private String encode(String url, String charset) throws UnsupportedEncodingException {
        String encoded = URLEncoder.encode(url, charset);
        StringBuilder buf = new StringBuilder(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }
}

