/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri.parser;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.DataReturnAgent;
import org.ballerinalang.net.uri.parser.Expression;
import org.ballerinalang.net.uri.parser.Literal;
import org.ballerinalang.net.uri.parser.Variable;

public abstract class Node<DataType, InboundMsgType> {
    protected String token;
    protected DataElement<DataType, InboundMsgType> dataElement;
    protected List<Node<DataType, InboundMsgType>> childNodesList = new LinkedList<Node<DataType, InboundMsgType>>();

    protected Node(DataElement<DataType, InboundMsgType> dataElement, String token) {
        this.dataElement = dataElement;
        this.token = token;
    }

    public DataElement<DataType, InboundMsgType> getDataElement() {
        return this.dataElement;
    }

    public Node<DataType, InboundMsgType> addChild(Node<DataType, InboundMsgType> childNode) throws URITemplateException {
        Node<DataType, InboundMsgType> node = childNode;
        Node<DataType, InboundMsgType> matchingChildNode = this.getMatchingChildNode(childNode, this.childNodesList);
        if (matchingChildNode != null) {
            node = matchingChildNode;
        } else {
            this.childNodesList.add(node);
        }
        Collections.sort(this.childNodesList, (o1, o2) -> this.getIntValue((Node)o2) - this.getIntValue((Node)o1));
        return node;
    }

    public boolean matchAll(String uriFragment, Map<String, String> variables, int start, InboundMsgType inboundMsg, DataReturnAgent<DataType> dataReturnAgent) {
        int matchLength = this.match(uriFragment, variables);
        if (matchLength < 0) {
            return false;
        }
        if (matchLength == uriFragment.length()) {
            return this.dataElement.getData(inboundMsg, dataReturnAgent);
        }
        if (matchLength >= uriFragment.length()) {
            return false;
        }
        String subUriFragment = this.nextURIFragment(uriFragment, matchLength);
        String subPath = this.nextSubPath(subUriFragment);
        for (Node<DataType, InboundMsgType> childNode : this.childNodesList) {
            boolean isFound;
            if (childNode instanceof Literal) {
                String regex = childNode.getToken();
                if (regex.equals("*")) {
                    regex = "." + regex;
                    if (!subPath.matches(regex) || !(isFound = childNode.matchAll(subUriFragment, variables, start + matchLength, inboundMsg, dataReturnAgent))) continue;
                    this.setUriPostFix(variables, subUriFragment);
                    return true;
                }
                if (!subPath.contains(regex) || !(isFound = childNode.matchAll(subUriFragment, variables, start + matchLength, inboundMsg, dataReturnAgent))) continue;
                return true;
            }
            isFound = childNode.matchAll(subUriFragment, variables, start + matchLength, inboundMsg, dataReturnAgent);
            if (!isFound) continue;
            return true;
        }
        return false;
    }

    private boolean hasDataElement(DataElement<DataType, InboundMsgType> dataElement) {
        return dataElement != null && dataElement.hasData();
    }

    private void setUriPostFix(Map<String, String> variables, String subUriFragment) {
        variables.putIfAbsent("EXTRA_PATH_INFO", "/" + subUriFragment);
    }

    abstract String expand(Map<String, String> var1);

    abstract int match(String var1, Map<String, String> var2);

    abstract String getToken();

    abstract char getFirstCharacter();

    private Node<DataType, InboundMsgType> getMatchingChildNode(Node<DataType, InboundMsgType> prospectiveChild, List<Node<DataType, InboundMsgType>> existingChildren) throws URITemplateException {
        boolean isExpression = prospectiveChild instanceof Expression;
        String prospectiveChildToken = prospectiveChild.getToken();
        for (Node<DataType, InboundMsgType> existingChild : existingChildren) {
            if (isExpression && existingChild instanceof Expression) {
                ((Expression)existingChild).variableList.add(new Variable(prospectiveChild.token));
                existingChild.token = existingChild.token + "+" + prospectiveChild.token;
                return existingChild;
            }
            if (!existingChild.getToken().equals(prospectiveChildToken)) continue;
            return existingChild;
        }
        return null;
    }

    private int getIntValue(Node node) {
        if (node instanceof Literal) {
            if (node.getToken().equals("*")) {
                return 0;
            }
            return node.getToken().length() + 5;
        }
        return 1;
    }

    private String nextURIFragment(String uri, int matchLength) {
        String uriFragment = uri;
        uriFragment = uriFragment.startsWith("/") ? uriFragment.substring(matchLength) : (uriFragment.contains("/") ? (uriFragment.charAt(matchLength) == '/' ? uriFragment.substring(matchLength + 1) : uriFragment.substring(matchLength)) : uriFragment.substring(matchLength));
        return uriFragment;
    }

    private String nextSubPath(String uriFragment) {
        String subPath = uriFragment.contains("/") ? uriFragment.substring(0, uriFragment.indexOf("/")) : uriFragment;
        return subPath;
    }
}

