/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.ballerinalang.net.http.websocket.server.WebSocketServicesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(HTTPServicesRegistry.class);
    protected Map<String, ServicesMapHolder> servicesMapByHost = new ConcurrentHashMap<String, ServicesMapHolder>();
    protected Map<String, HttpService> servicesByBasePath;
    protected List<String> sortedServiceURIs;
    private final WebSocketServicesRegistry webSocketServicesRegistry;
    private Scheduler scheduler;

    public HTTPServicesRegistry(WebSocketServicesRegistry webSocketServicesRegistry) {
        this.webSocketServicesRegistry = webSocketServicesRegistry;
    }

    public HttpService getServiceInfo(String basepath) {
        return this.servicesByBasePath.get(basepath);
    }

    public ServicesMapHolder getServicesMapHolder(String hostName) {
        return this.servicesMapByHost.get(hostName);
    }

    public Map<String, HttpService> getServicesByHost(String hostName) {
        return this.servicesMapByHost.get(hostName).servicesByBasePath;
    }

    public List<String> getSortedServiceURIsByHost(String hostName) {
        return this.servicesMapByHost.get(hostName).sortedServiceURIs;
    }

    public void registerService(ObjectValue service) {
        List<HttpService> httpServices = HttpService.buildHttpService(service);
        for (HttpService httpService : httpServices) {
            String hostName = httpService.getHostName();
            if (this.servicesMapByHost.get(hostName) == null) {
                this.servicesByBasePath = new ConcurrentHashMap<String, HttpService>();
                this.sortedServiceURIs = new CopyOnWriteArrayList<String>();
                this.servicesMapByHost.put(hostName, new ServicesMapHolder(this.servicesByBasePath, this.sortedServiceURIs));
            } else {
                this.servicesByBasePath = this.getServicesByHost(hostName);
                this.sortedServiceURIs = this.getSortedServiceURIsByHost(hostName);
            }
            String basePath = httpService.getBasePath();
            if (this.servicesByBasePath.containsKey(basePath)) {
                String errorMessage = hostName.equals("b7a.default") ? "'" : "' under host name : '" + hostName + "'";
                throw BallerinaErrors.createError((String)("Service registration failed: two services have the same basePath : '" + basePath + errorMessage));
            }
            this.servicesByBasePath.put(basePath, httpService);
            String errLog = String.format("Service deployed : %s with context %s", HTTPServicesRegistry.sanitizeText(service.getType().getName()), HTTPServicesRegistry.sanitizeText(basePath));
            logger.info(errLog);
            this.sortedServiceURIs.add(basePath);
            this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
            this.registerWebSocketUpgradeService(httpService);
        }
    }

    private void registerWebSocketUpgradeService(HttpService httpService) {
        httpService.getUpgradeToWebSocketResources().forEach(upgradeToWebSocketResource -> {
            WebSocketServerService webSocketService = new WebSocketServerService(this.sanitizeBasePath(httpService.getBasePath()), (HttpResource)upgradeToWebSocketResource, this.getUpgradeService((HttpResource)upgradeToWebSocketResource), this.scheduler);
            this.webSocketServicesRegistry.registerService(webSocketService);
        });
    }

    private ObjectValue getUpgradeService(HttpResource upgradeToWebSocketResource) {
        MapValue resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(upgradeToWebSocketResource.getBalResource());
        MapValue webSocketConfig = resourceConfigAnnotation.getMapValue("webSocketUpgrade");
        return (ObjectValue)webSocketConfig.get((Object)"upgradeService");
    }

    private String sanitizeBasePath(String basePath) {
        if (!(basePath = basePath.trim()).startsWith("/")) {
            basePath = "/".concat(basePath);
        }
        if (basePath.endsWith("/") && basePath.length() != 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public String findTheMostSpecificBasePath(String requestURIPath, Map<String, HttpService> services, List<String> sortedServiceURIs) {
        for (String key : sortedServiceURIs) {
            if (!requestURIPath.toLowerCase().contains(key.toString().toLowerCase())) continue;
            if (requestURIPath.length() <= key.toString().length()) {
                return key.toString();
            }
            if (!requestURIPath.startsWith(key.toString().concat("/"))) continue;
            return key.toString();
        }
        if (services.containsKey("/")) {
            return "/";
        }
        return null;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void unRegisterService(ObjectValue service) {
        List<HttpService> httpServices = HttpService.buildHttpService(service);
        for (HttpService httpService : httpServices) {
            String hostName = httpService.getHostName();
            ServicesMapHolder servicesMapHolder = this.servicesMapByHost.get(hostName);
            if (servicesMapHolder == null) continue;
            this.servicesByBasePath = this.getServicesByHost(hostName);
            this.sortedServiceURIs = this.getSortedServiceURIsByHost(hostName);
            String basePath = httpService.getBasePath();
            if (!this.servicesByBasePath.containsKey(basePath)) continue;
            this.servicesByBasePath.remove(basePath);
            this.sortedServiceURIs.remove(basePath);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Service detached : %s with context %s", HTTPServicesRegistry.sanitizeText(service.getType().getName()), HTTPServicesRegistry.sanitizeText(basePath)));
            }
            this.sortedServiceURIs.sort((basePath1, basePath2) -> basePath2.length() - basePath1.length());
        }
    }

    private static String sanitizeText(String text) {
        return text.replace("\r", " ").replace("\n", " ");
    }

    protected class ServicesMapHolder {
        private Map<String, HttpService> servicesByBasePath;
        private List<String> sortedServiceURIs;

        public ServicesMapHolder(Map<String, HttpService> servicesByBasePath, List<String> sortedServiceURIs) {
            this.servicesByBasePath = servicesByBasePath;
            this.sortedServiceURIs = sortedServiceURIs;
        }
    }
}

