/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.CorsHeaders;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpResourceDataElement;
import org.ballerinalang.net.http.HttpResourceElementFactory;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.ballerinalang.net.uri.URITemplate;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.Literal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpService
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);
    protected static final String BASE_PATH_FIELD = "basePath";
    private static final String COMPRESSION_FIELD = "compression";
    private static final String CORS_FIELD = "cors";
    private static final String VERSIONING_FIELD = "versioning";
    private static final String HOST_FIELD = "host";
    private ObjectValue balService;
    private List<HttpResource> resources;
    private List<HttpResource> upgradeToWebSocketResources;
    private List<String> allAllowedMethods;
    private String basePath;
    private CorsHeaders corsHeaders;
    private URITemplate<HttpResource, HttpCarbonMessage> uriTemplate;
    private boolean keepAlive = true;
    private MapValue<String, Object> compression;
    private String hostName;
    private boolean interruptible;
    private String chunkingConfig;

    protected HttpService(ObjectValue service) {
        this.balService = service;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    private void setCompressionConfig(MapValue<String, Object> compression) {
        this.compression = compression;
    }

    public MapValue<String, Object> getCompressionConfig() {
        return this.compression;
    }

    public void setChunkingConfig(String chunkingConfig) {
        this.chunkingConfig = chunkingConfig;
    }

    public String getChunkingConfig() {
        return this.chunkingConfig;
    }

    public String getName() {
        return HttpUtil.getServiceName(this.balService);
    }

    public String getPackage() {
        return this.balService.getType().getPackage().getName();
    }

    public ObjectValue getBalService() {
        return this.balService;
    }

    public List<HttpResource> getResources() {
        return this.resources;
    }

    public void setResources(List<HttpResource> resources) {
        this.resources = resources;
    }

    public List<String> getAllAllowedMethods() {
        return this.allAllowedMethods;
    }

    public void setAllAllowedMethods(List<String> allAllowMethods) {
        this.allAllowedMethods = allAllowMethods;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath == null || basePath.trim().isEmpty() ? "/".concat(this.getName().startsWith("$") ? "" : this.getName()) : HttpUtil.sanitizeBasePath(basePath);
    }

    public CorsHeaders getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(CorsHeaders corsHeaders) {
        this.corsHeaders = corsHeaders;
        if (this.corsHeaders == null || !this.corsHeaders.isAvailable()) {
            return;
        }
        if (this.corsHeaders.getAllowOrigins() == null) {
            this.corsHeaders.setAllowOrigins(Stream.of("*").collect(Collectors.toList()));
        }
        if (this.corsHeaders.getAllowMethods() == null) {
            this.corsHeaders.setAllowMethods(Stream.of("*").collect(Collectors.toList()));
        }
    }

    public List<HttpResource> getUpgradeToWebSocketResources() {
        return this.upgradeToWebSocketResources;
    }

    public void setUpgradeToWebSocketResources(List<HttpResource> upgradeToWebSocketResources) {
        this.upgradeToWebSocketResources = upgradeToWebSocketResources;
    }

    public URITemplate<HttpResource, HttpCarbonMessage> getUriTemplate() throws URITemplateException {
        if (this.uriTemplate == null) {
            this.uriTemplate = new URITemplate<HttpResource, HttpCarbonMessage>(new Literal<HttpResource, HttpCarbonMessage>(new HttpResourceDataElement(), "/"));
        }
        return this.uriTemplate;
    }

    public static List<HttpService> buildHttpService(ObjectValue service) {
        String basePath;
        ArrayList<HttpService> serviceList = new ArrayList<HttpService>();
        ArrayList<String> basePathList = new ArrayList<String>();
        HttpService httpService = new HttpService(service);
        MapValue serviceConfig = HttpService.getHttpServiceConfigAnnotation(service);
        httpService.setInterruptible(HttpService.hasInterruptibleAnnotation(service));
        if (HttpUtil.checkConfigAnnotationAvailability(serviceConfig)) {
            httpService.setCompressionConfig((MapValue<String, Object>)((MapValue)serviceConfig.get((Object)COMPRESSION_FIELD)));
            httpService.setChunkingConfig(serviceConfig.get((Object)"chunking").toString());
            httpService.setCorsHeaders(CorsHeaders.buildCorsHeaders(serviceConfig.getMapValue(CORS_FIELD)));
            httpService.setHostName(serviceConfig.getStringValue(HOST_FIELD).trim());
            basePath = serviceConfig.getStringValue(BASE_PATH_FIELD).replaceAll("(?<!(http:|https:))//", "/");
            if (basePath.contains("{version}")) {
                HttpService.prepareBasePathList(serviceConfig.getMapValue(VERSIONING_FIELD), serviceConfig.getStringValue(BASE_PATH_FIELD), basePathList, httpService.getBalService().getType().getPackage().getVersion());
            } else {
                basePathList.add(basePath);
            }
        } else {
            log.debug("serviceConfig not specified in the Service instance, using default base path");
            basePath = httpService.getName().startsWith("$") ? "/" : "/".concat(httpService.getName());
            basePathList.add(basePath);
            httpService.setHostName("b7a.default");
        }
        HttpService.processResources(httpService);
        httpService.setAllAllowedMethods(DispatcherUtil.getAllResourceMethods(httpService));
        if (basePathList.size() == 1) {
            httpService.setBasePath((String)basePathList.get(0));
            serviceList.add(httpService);
            return serviceList;
        }
        for (String basePath2 : basePathList) {
            HttpService tempHttpService;
            try {
                tempHttpService = (HttpService)httpService.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BallerinaConnectorException("Service registration failed");
            }
            tempHttpService.setBasePath(basePath2);
            serviceList.add(tempHttpService);
        }
        return serviceList;
    }

    private static void processResources(HttpService httpService) {
        ArrayList<HttpResource> httpResources = new ArrayList<HttpResource>();
        ArrayList<HttpResource> upgradeToWebSocketResources = new ArrayList<HttpResource>();
        for (AttachedFunction resource : httpService.getBalService().getType().getAttachedFunctions()) {
            if (!Flags.isFlagOn((int)resource.flags, (int)262144)) continue;
            MapValue resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(resource);
            if (HttpService.websocketUpgradeResource(resourceConfigAnnotation)) {
                HttpResource upgradeResource = HttpResource.buildHttpResource(resource, httpService);
                upgradeToWebSocketResources.add(upgradeResource);
                continue;
            }
            HttpResource httpResource = HttpResource.buildHttpResource(resource, httpService);
            try {
                httpService.getUriTemplate().parse(httpResource.getPath(), httpResource, new HttpResourceElementFactory());
            }
            catch (UnsupportedEncodingException | URITemplateException e) {
                throw new BallerinaConnectorException(e.getMessage());
            }
            httpResources.add(httpResource);
        }
        httpService.setResources(httpResources);
        httpService.setUpgradeToWebSocketResources(upgradeToWebSocketResources);
    }

    private static boolean websocketUpgradeResource(MapValue resourceConfigAnnotation) {
        return HttpUtil.checkConfigAnnotationAvailability(resourceConfigAnnotation) && resourceConfigAnnotation.getMapValue("webSocketUpgrade") != null;
    }

    private static void prepareBasePathList(MapValue versioningConfig, String basePath, List<String> basePathList, String packageVersion) {
        String patternAnnotValue = "v.{major}.{minor}";
        Boolean allowNoVersionAnnotValue = false;
        Boolean matchMajorVersionAnnotValue = false;
        if (versioningConfig != null) {
            patternAnnotValue = versioningConfig.getStringValue("pattern");
            allowNoVersionAnnotValue = versioningConfig.getBooleanValue("allowNoVersion");
            matchMajorVersionAnnotValue = versioningConfig.getBooleanValue("matchMajorVersion");
        }
        patternAnnotValue = patternAnnotValue.toLowerCase();
        basePathList.add(HttpService.replaceServiceVersion(basePath, packageVersion, patternAnnotValue));
        if (allowNoVersionAnnotValue.booleanValue()) {
            basePathList.add(basePath.replace("{version}", "").replace("//", "/"));
        }
        if (matchMajorVersionAnnotValue.booleanValue()) {
            String patternWithMajor = patternAnnotValue.replace("{minor}", "");
            patternWithMajor = patternWithMajor.endsWith(".") ? patternWithMajor.substring(0, patternWithMajor.length() - 1) : patternWithMajor;
            basePathList.add(HttpService.replaceServiceVersion(basePath, packageVersion, patternWithMajor));
        }
    }

    private static String replaceServiceVersion(String basePath, String version, String pattern) {
        String minorVersion;
        pattern = pattern.toLowerCase();
        String[] versionElements = version.split("\\.");
        String majorVersion = versionElements[0];
        String string = minorVersion = versionElements.length > 1 ? versionElements[1] : "";
        if (pattern.contains("{major}") || pattern.contains("{minor}")) {
            String patternReplaced = pattern.replace("{major}", majorVersion);
            String result = patternReplaced.replace("{minor}", minorVersion);
            return basePath.replace("{version}", result);
        }
        throw new BallerinaConnectorException("Invalid versioning pattern: expect \"{major},{minor}\" elements");
    }

    private static MapValue getHttpServiceConfigAnnotation(ObjectValue service) {
        return HttpService.getServiceConfigAnnotation(service, "ballerina/http", "ServiceConfig");
    }

    protected static MapValue getServiceConfigAnnotation(ObjectValue service, String packagePath, String annotationName) {
        return (MapValue)service.getType().getAnnotation(packagePath.replaceAll("(?<!(http:|https:))//", "/"), annotationName);
    }

    private static boolean hasInterruptibleAnnotation(ObjectValue service) {
        return service.getType().getAnnotation("ballerina/builtin", "interruptible") != null;
    }

    private String urlDecode(String basePath) {
        try {
            basePath = URLDecoder.decode(basePath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        return basePath;
    }
}

