/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.ResponseHandle;

public class GetNextPromise
extends AbstractHTTPAction {
    public static Object getNextPromise(ObjectValue clientObj, ObjectValue handleObj) {
        Strand strand = Scheduler.getStrand();
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        DataContext dataContext = new DataContext(strand, clientConnector, new NonBlockingCallback(strand), handleObj, null);
        ResponseHandle responseHandle = (ResponseHandle)handleObj.getNativeData("transport_handle");
        if (responseHandle == null) {
            throw new BallerinaException("invalid http handle");
        }
        clientConnector.getNextPushPromise(responseHandle).setPushPromiseListener((HttpConnectorListener)new PromiseListener(dataContext));
        return null;
    }

    private static class PromiseListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        PromiseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public void onPushPromise(Http2PushPromise pushPromise) {
            ObjectValue pushPromiseObj = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"PushPromise", (Object[])new Object[]{pushPromise.getPath(), pushPromise.getMethod()});
            HttpUtil.populatePushPromiseStruct(pushPromiseObj, pushPromise);
            this.dataContext.notifyInboundResponseStatus(pushPromiseObj, null);
        }
    }
}

