/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class GetPromisedResponse
extends AbstractHTTPAction {
    public static Object getPromisedResponse(ObjectValue clientObj, ObjectValue pushPromiseObj) {
        Strand strand = Scheduler.getStrand();
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        DataContext dataContext = new DataContext(strand, clientConnector, new NonBlockingCallback(strand), pushPromiseObj, null);
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, null);
        if (http2PushPromise == null) {
            throw new BallerinaException("invalid push promise");
        }
        clientConnector.getPushResponse(http2PushPromise).setPushResponseListener((HttpConnectorListener)new PushResponseListener(dataContext), http2PushPromise.getPromisedStreamId());
        return null;
    }

    private static class PushResponseListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        PushResponseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public void onPushResponse(int promisedId, HttpCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyInboundResponseStatus(HttpUtil.createResponseStruct(httpCarbonMessage), null);
        }

        public void onError(Throwable throwable) {
            ErrorValue httpConnectorError = HttpUtil.createHttpError(throwable.getMessage());
            this.dataContext.notifyInboundResponseStatus(null, httpConnectorError);
        }
    }
}

