/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.ResponseHandle;

public class GetResponse
extends AbstractHTTPAction {
    public static Object getResponse(ObjectValue clientObj, ObjectValue handleObj) {
        Strand strand = Scheduler.getStrand();
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        DataContext dataContext = new DataContext(strand, clientConnector, new NonBlockingCallback(strand), handleObj, null);
        ResponseHandle responseHandle = (ResponseHandle)handleObj.getNativeData("transport_handle");
        if (responseHandle == null) {
            throw new BallerinaException("invalid http handle");
        }
        clientConnector.getResponse(responseHandle).setHttpConnectorListener((HttpConnectorListener)new ResponseListener(dataContext));
        return null;
    }

    private static class ResponseListener
    implements HttpConnectorListener {
        private DataContext dataContext;

        ResponseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public void onMessage(HttpCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyInboundResponseStatus(HttpUtil.createResponseStruct(httpCarbonMessage), null);
        }

        public void onError(Throwable throwable) {
            ErrorValue httpConnectorError = HttpUtil.createHttpError(throwable.getMessage());
            this.dataContext.notifyInboundResponseStatus(null, httpConnectorError);
        }
    }
}

