/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.websocketconnector;

import io.netty.channel.ChannelFuture;
import java.nio.ByteBuffer;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConnector {
    private static final Logger log = LoggerFactory.getLogger(WebSocketConnector.class);

    public static Object externPushText(ObjectValue wsConnection, String text, boolean finalFrame) {
        Strand strand = Scheduler.getStrand();
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        WebSocketObservabilityUtil.observeResourceInvocation(strand, connectionInfo, "pushText");
        try {
            ChannelFuture future = connectionInfo.getWebSocketConnection().pushText(text, finalFrame);
            WebSocketUtil.handleWebSocketCallback(callback, future, log, connectionInfo);
            WebSocketObservabilityUtil.observeSend("text", connectionInfo);
        }
        catch (Exception e) {
            log.error("Error occurred when pushing text data", (Throwable)e);
            WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "text", e.getMessage());
            WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, callback, e);
        }
        return null;
    }

    public static Object pushBinary(ObjectValue wsConnection, ArrayValue binaryData, boolean finalFrame) {
        Strand strand = Scheduler.getStrand();
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        WebSocketObservabilityUtil.observeResourceInvocation(strand, connectionInfo, "pushBinary");
        try {
            ChannelFuture webSocketChannelFuture = connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(binaryData.getBytes()), finalFrame);
            WebSocketUtil.handleWebSocketCallback(callback, webSocketChannelFuture, log, connectionInfo);
            WebSocketObservabilityUtil.observeSend("binary", connectionInfo);
        }
        catch (Exception e) {
            log.error("Error occurred when pushing binary data", (Throwable)e);
            WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "binary", e.getMessage());
            WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, callback, e);
        }
        return null;
    }

    public static Object ping(ObjectValue wsConnection, ArrayValue binaryData) {
        Strand strand = Scheduler.getStrand();
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        WebSocketObservabilityUtil.observeResourceInvocation(strand, connectionInfo, "ping");
        try {
            ChannelFuture future = connectionInfo.getWebSocketConnection().ping(ByteBuffer.wrap(binaryData.getBytes()));
            WebSocketUtil.handleWebSocketCallback(callback, future, log, connectionInfo);
            WebSocketObservabilityUtil.observeSend("ping", connectionInfo);
        }
        catch (Exception e) {
            log.error("Error occurred when pinging", (Throwable)e);
            WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "ping", e.getMessage());
            WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, callback, e);
        }
        return null;
    }

    public static Object pong(ObjectValue wsConnection, ArrayValue binaryData) {
        Strand strand = Scheduler.getStrand();
        NonBlockingCallback callback = new NonBlockingCallback(strand);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)wsConnection.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        WebSocketObservabilityUtil.observeResourceInvocation(strand, connectionInfo, "pong");
        try {
            ChannelFuture future = connectionInfo.getWebSocketConnection().pong(ByteBuffer.wrap(binaryData.getBytes()));
            WebSocketUtil.handleWebSocketCallback(callback, future, log, connectionInfo);
            WebSocketObservabilityUtil.observeSend("pong", connectionInfo);
        }
        catch (Exception e) {
            log.error("Error occurred when ponging", (Throwable)e);
            WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(wsConnection), "message_sent", "pong", e.getMessage());
            WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, callback, e);
        }
        return null;
    }
}

