/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler.websocket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public abstract class WebSocketResourceValidator {
    static final String INVALID_RESOURCE_SIGNATURE_FOR = "Invalid resource signature for ";
    static final String RESOURCE_IN_SERVICE = " resource in service ";
    protected DiagnosticLog dlog;
    private Map<String, Runnable> validationMap = new HashMap<String, Runnable>();
    protected BLangFunction resource;
    List<BLangSimpleVariable> paramDetails;

    WebSocketResourceValidator(DiagnosticLog dlog, BLangFunction resource) {
        this.dlog = dlog;
        this.resource = resource;
        this.paramDetails = resource.getParameters();
        this.validationMap.put("onOpen", this::validateOnOpenResource);
        this.validationMap.put("onIdleTimeout", this::validateOnIdleTimeoutResource);
        this.validationMap.put("onText", this::validateOnTextResource);
        this.validationMap.put("onBinary", this::validateOnBinaryResource);
        this.validationMap.put("onPing", this::validateOnPingPongResource);
        this.validationMap.put("onPong", this::validateOnPingPongResource);
        this.validationMap.put("onClose", this::validateOnCloseResource);
        this.validationMap.put("onError", this::validateOnErrorResource);
    }

    public void validate() {
        String name = this.resource.getName().getValue();
        if (this.validationMap.containsKey(name)) {
            this.validateEndpointParameter();
            this.validationMap.get(name).run();
        } else {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)("Invalid resource name " + this.resource.getName().getValue() + " in service "));
        }
    }

    abstract void validateOnOpenResource();

    void validateOnIdleTimeoutResource() {
        this.validateParamDetailsSize(1);
    }

    private void validateOnTextResource() {
        this.validateParamDetailsSize();
        if (this.paramDetails.size() < 2) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": A second parameter needs to be specified"));
        }
        BType secondParamType = this.paramDetails.get((int)1).type;
        int secondParamTypeTag = secondParamType.tag;
        if (secondParamTypeTag != 5 && secondParamTypeTag != 7 && secondParamTypeTag != 8 && secondParamTypeTag != 12 && (secondParamTypeTag != 19 || secondParamType instanceof BArrayType && ((BArrayType)secondParamType).getElementType().tag != 2)) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The second parameter should be a string, json, xml, byte[] or a record type"));
        } else if (this.paramDetails.size() == 3) {
            if (!"string".equals(secondParamType.toString())) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": Final fragment is not valid if the second parameter is not a string"));
            } else if (!"boolean".equals(this.paramDetails.get((int)2).type.toString())) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The third parameter should be a boolean"));
            }
        }
    }

    private void validateOnBinaryResource() {
        this.validateParamDetailsSize();
        if (this.paramDetails.size() < 2 || !"byte[]".equals(this.paramDetails.get((int)1).type.toString())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The second parameter should be a byte[]"));
        }
        if (this.paramDetails.size() == 3 && !"boolean".equals(this.paramDetails.get((int)2).type.toString())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The third parameter should be a boolean"));
        }
    }

    private void validateOnPingPongResource() {
        this.validateParamDetailsSize(2);
        if (this.paramDetails.size() < 2 || !"byte[]".equals(this.paramDetails.get((int)1).type.toString())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The second parameter should be a byte[]"));
        }
    }

    private void validateOnCloseResource() {
        this.validateParamDetailsSize(3);
        if (this.paramDetails.size() < 2 || 1 != this.paramDetails.get((int)1).type.tag) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The second parameter should be an int"));
        }
        if (this.paramDetails.size() < 3 || 5 != this.paramDetails.get((int)2).type.tag) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The third parameter should be a string"));
        }
    }

    private void validateOnErrorResource() {
        this.validateParamDetailsSize(2);
        if (this.paramDetails.size() < 2 || !"error".equals(this.paramDetails.get((int)1).type.toString())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)String.format("Invalid resource signature for %s resource in service : The second parameter should be an error", this.resource.getName().getValue()));
        }
    }

    private void validateParamDetailsSize(int expectedSize) {
        if (this.paramDetails == null || this.paramDetails.size() != expectedSize) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": Expected parameter count = " + expectedSize));
        }
    }

    private void validateParamDetailsSize() {
        if (this.paramDetails == null || this.paramDetails.size() < 2 || this.paramDetails.size() > 3) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)this.resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + this.resource.getName().getValue() + RESOURCE_IN_SERVICE + ": Unexpected parameter count"));
        }
    }

    abstract void validateEndpointParameter();
}

