/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.net.http.compiler.websocket.WebSocketServiceResourceValidator;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="http", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="http", name="WebSocketCaller")})
public class WebSocketServiceCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        List resources = serviceNode.getResources();
        if (!resources.isEmpty() && !((BLangFunction)resources.get(0)).getParameters().isEmpty() && "ballerina/http:Caller".equals(((BLangSimpleVariable)((BLangFunction)resources.get((int)0)).getParameters().get((int)0)).type.toString())) {
            return;
        }
        this.validateAnnotationCountAndPath(serviceNode, annotations);
        resources.forEach(res -> new WebSocketServiceResourceValidator(this.dlog, (BLangFunction)res).validate());
    }

    private void validateAnnotationCountAndPath(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        int count = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("WebSocketServiceConfig")) continue;
            this.validatePathAnnotationForPathParam(annotation);
            ++count;
        }
        if (count > 1) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There cannot be more than one WebSocketService annotations");
        }
    }

    private void validatePathAnnotationForPathParam(AnnotationAttachmentNode annotation) {
        BLangExpression valueExpr;
        String pathParam;
        ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> keyValues = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
        for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)annotation.getExpression()).fields) {
            keyValues.add((BLangRecordLiteral.BLangRecordKeyValueField)field);
        }
        Optional<BLangRecordLiteral.BLangRecordKeyValueField> pathPair = keyValues.stream().filter(pair -> pair.key.toString().equals("path")).findAny();
        if (pathPair.isPresent() && ((pathParam = (valueExpr = pathPair.get().valueExpr).toString()).contains("{") || pathParam.contains("}"))) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)valueExpr.getPosition(), (CharSequence)"Path params are not supported in service path");
        }
    }
}

