/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.websocket.WebSocketConstants;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionManager;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;

public class AcceptWebSocketUpgrade {
    private static final Logger log = LoggerFactory.getLogger(AcceptWebSocketUpgrade.class);

    public static Object acceptWebSocketUpgrade(ObjectValue httpCaller, MapValue<String, String> headers) {
        NonBlockingCallback callback = new NonBlockingCallback(Scheduler.getStrand());
        try {
            WebSocketHandshaker webSocketHandshaker = (WebSocketHandshaker)httpCaller.getNativeData("WEBSOCKET_MESSAGE");
            WebSocketServerService webSocketService = (WebSocketServerService)httpCaller.getNativeData("WebSocketService");
            WebSocketConnectionManager connectionManager = (WebSocketConnectionManager)httpCaller.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_MANAGER");
            if (webSocketHandshaker == null || webSocketService == null || connectionManager == null) {
                callback.notifyFailure((BError)new WebSocketException(WebSocketConstants.ErrorCode.WsInvalidHandshakeError, "Not a WebSocket upgrade request. Cannot upgrade from HTTP to WS"));
                return null;
            }
            ServerHandshakeFuture future = webSocketHandshaker.handshake(webSocketService.getNegotiableSubProtocols(), webSocketService.getIdleTimeoutInSeconds() * 1000, (HttpHeaders)AcceptWebSocketUpgrade.populateAndGetHttpHeaders(headers), webSocketService.getMaxFrameSize());
            future.setHandshakeListener((ServerHandshakeListener)new AcceptUpgradeHandshakeListener(webSocketService, connectionManager, callback));
        }
        catch (Exception e) {
            log.error("Error when upgrading to WebSocket", (Throwable)e);
            callback.notifyFailure((BError)WebSocketUtil.createErrorByType(e));
        }
        return null;
    }

    private static DefaultHttpHeaders populateAndGetHttpHeaders(MapValue<String, String> headers) {
        Object[] keys;
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        for (Object key : keys = headers.getKeys()) {
            httpHeaders.add(key.toString(), headers.get((Object)key.toString()));
        }
        return httpHeaders;
    }

    private AcceptWebSocketUpgrade() {
    }

    private static class AcceptUpgradeHandshakeListener
    implements ServerHandshakeListener {
        private final WebSocketServerService webSocketService;
        private final WebSocketConnectionManager connectionManager;
        private final NonBlockingCallback callback;

        AcceptUpgradeHandshakeListener(WebSocketServerService webSocketService, WebSocketConnectionManager connectionManager, NonBlockingCallback callback) {
            this.webSocketService = webSocketService;
            this.connectionManager = connectionManager;
            this.callback = callback;
        }

        public void onSuccess(WebSocketConnection webSocketConnection) {
            ObjectValue webSocketEndpoint = WebSocketUtil.createAndPopulateWebSocketCaller(webSocketConnection, this.webSocketService, this.connectionManager);
            this.callback.setReturnValues((Object)webSocketEndpoint);
            this.callback.notifySuccess();
        }

        public void onError(Throwable throwable) {
            String msg = "WebSocket handshake failed: ";
            log.error(msg, throwable);
            this.callback.notifyFailure((BError)new WebSocketException(WebSocketConstants.ErrorCode.WsInvalidHandshakeError, msg + throwable.getMessage()));
        }
    }
}

