/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.serviceendpoint;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.serviceendpoint.AbstractHttpNativeFunction;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.ballerinalang.net.http.websocket.server.WebSocketServicesRegistry;

public class Register
extends AbstractHttpNativeFunction {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object register(ObjectValue serviceEndpoint, ObjectValue service, Object annotationData) {
        HTTPServicesRegistry httpServicesRegistry = Register.getHttpServicesRegistry(serviceEndpoint);
        WebSocketServicesRegistry webSocketServicesRegistry = Register.getWebSocketServicesRegistry(serviceEndpoint);
        Strand strand = Scheduler.getStrand();
        httpServicesRegistry.setScheduler(strand.scheduler);
        AttachedFunction[] resourceList = service.getType().getAttachedFunctions();
        try {
            BType param;
            if (resourceList.length > 0 && (param = resourceList[0].getParameterType()[0]) != null) {
                String callerType = param.getQualifiedName();
                if ("ballerina/http:Caller".equals(callerType)) {
                    httpServicesRegistry.registerService(service);
                    return null;
                }
                if ("ballerina/http:WebSocketCaller".equals(callerType)) {
                    webSocketServicesRegistry.registerService(new WebSocketServerService(service, strand.scheduler));
                    return null;
                }
                if (!"ballerina/http:WebSocketClient".equals(callerType)) return HttpUtil.createHttpError("Invalid http Service");
                return new WebSocketException("Client service cannot be attached to the Listener");
            }
            httpServicesRegistry.registerService(service);
            return null;
        }
        catch (WebSocketException ex) {
            return ex;
        }
    }
}

