/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket;

import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.CorruptedFrameException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.net.http.HttpDispatcher;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketResourceCallback;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObserverContext;
import org.ballerinalang.net.http.websocket.server.OnUpgradeResourceCallback;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionManager;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlSignal;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class WebSocketResourceDispatcher {
    private static final Logger log = LoggerFactory.getLogger(WebSocketResourceDispatcher.class);

    private WebSocketResourceDispatcher() {
    }

    public static void dispatchUpgrade(WebSocketHandshaker webSocketHandshaker, WebSocketServerService wsService, MapValue httpEndpointConfig, WebSocketConnectionManager connectionManager) {
        HttpResource onUpgradeResource = wsService.getUpgradeResource();
        webSocketHandshaker.getHttpCarbonRequest().setProperty("RESOURCES_CORS", (Object)onUpgradeResource.getCorsHeaders());
        AttachedFunction balResource = onUpgradeResource.getBalResource();
        Object[] signatureParams = HttpDispatcher.getSignatureParameters(onUpgradeResource, (HttpCarbonMessage)webSocketHandshaker.getHttpCarbonRequest(), httpEndpointConfig);
        ObjectValue httpCaller = (ObjectValue)signatureParams[0];
        httpCaller.addNativeData("WEBSOCKET_MESSAGE", (Object)webSocketHandshaker);
        httpCaller.addNativeData("WebSocketService", (Object)wsService);
        httpCaller.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_MANAGER", (Object)connectionManager);
        Executor.submit((Scheduler)wsService.getScheduler(), (ObjectValue)onUpgradeResource.getParentService().getBalService(), (String)balResource.getName(), (CallableUnitCallback)new OnUpgradeResourceCallback(webSocketHandshaker, wsService, connectionManager), new HashMap(), (Object[])signatureParams);
    }

    public static void dispatchOnOpen(WebSocketConnection webSocketConnection, ObjectValue webSocketCaller, WebSocketServerService wsService) {
        AttachedFunction onOpenResource = wsService.getResourceByName("onOpen");
        if (onOpenResource != null) {
            WebSocketResourceDispatcher.executeOnOpenResource(wsService, onOpenResource, webSocketCaller, webSocketConnection);
        } else {
            webSocketConnection.readNextFrame();
        }
    }

    private static void executeOnOpenResource(WebSocketService wsService, AttachedFunction onOpenResource, ObjectValue webSocketEndpoint, final WebSocketConnection webSocketConnection) {
        BType[] parameterTypes = onOpenResource.getParameterType();
        Object[] bValues = new Object[parameterTypes.length * 2];
        bValues[0] = webSocketEndpoint;
        bValues[1] = true;
        final WebSocketConnectionInfo connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketEndpoint);
        CallableUnitCallback onOpenCallableUnitCallback = new CallableUnitCallback(){

            public void notifySuccess() {
                webSocketConnection.readNextFrame();
            }

            public void notifyFailure(ErrorValue error) {
                ErrorHandlerUtils.printError((String)("error: " + error.getPrintableStackTrace()));
                WebSocketUtil.closeDuringUnexpectedCondition(webSocketConnection);
                WebSocketObservabilityUtil.observeError(connectionInfo, "resource_invocation", "onOpen", error.getMessage());
            }
        };
        WebSocketResourceDispatcher.executeResource(wsService, onOpenCallableUnitCallback, bValues, connectionInfo, "onOpen");
    }

    public static void dispatchOnText(WebSocketConnectionInfo connectionInfo, WebSocketTextMessage textMessage) {
        WebSocketObservabilityUtil.observeOnMessage("text", connectionInfo);
        try {
            WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            AttachedFunction onTextMessageResource = wsService.getResourceByName("onText");
            if (onTextMessageResource == null) {
                webSocketConnection.readNextFrame();
                return;
            }
            BType[] parameterTypes = onTextMessageResource.getParameterType();
            Object[] bValues = new Object[parameterTypes.length * 2];
            bValues[0] = connectionInfo.getWebSocketEndpoint();
            bValues[1] = true;
            boolean finalFragment = textMessage.isFinalFragment();
            BType dataType = parameterTypes[1];
            int dataTypeTag = dataType.getTag();
            if (dataTypeTag == 5) {
                bValues[2] = textMessage.getText();
                bValues[3] = true;
                if (parameterTypes.length == 3) {
                    bValues[4] = finalFragment;
                    bValues[5] = true;
                }
                WebSocketResourceDispatcher.executeResource(wsService, new WebSocketResourceCallback(connectionInfo, "onText"), bValues, connectionInfo, "onText");
            } else if (WebSocketResourceDispatcher.isDataBindingSupported(dataTypeTag)) {
                WebSocketConnectionInfo.StringAggregator stringAggregator = connectionInfo.createIfNullAndGetStringAggregator();
                if (finalFragment) {
                    stringAggregator.appendAggregateString(textMessage.getText());
                    Object aggregate = WebSocketResourceDispatcher.getAggregatedObject(webSocketConnection, dataType, stringAggregator.getAggregateString(), connectionInfo);
                    if (aggregate != null) {
                        bValues[2] = aggregate;
                        bValues[3] = true;
                        WebSocketResourceDispatcher.executeResource(wsService, new WebSocketResourceCallback(connectionInfo, "onText"), bValues, connectionInfo, "onText");
                    }
                    stringAggregator.resetAggregateString();
                } else {
                    stringAggregator.appendAggregateString(textMessage.getText());
                    webSocketConnection.readNextFrame();
                }
            }
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", e.getMessage());
        }
    }

    private static boolean isDataBindingSupported(int dataTypeTag) {
        return dataTypeTag == 7 || dataTypeTag == 12 || dataTypeTag == 8 || dataTypeTag == 20;
    }

    private static Object getAggregatedObject(WebSocketConnection webSocketConnection, BType dataType, String aggregateString, WebSocketConnectionInfo connectionInfo) {
        try {
            switch (dataType.getTag()) {
                case 7: {
                    return JSONParser.parse((String)aggregateString);
                }
                case 8: {
                    XMLValue bxml = XMLFactory.parse((String)aggregateString);
                    if (bxml.getNodeType() != XMLNodeType.SEQUENCE) {
                        throw new WebSocketException("Invalid XML data");
                    }
                    return bxml;
                }
                case 12: {
                    return JSONUtils.convertJSONToRecord((Object)JSONParser.parse((String)aggregateString), (BStructureType)((BStructureType)dataType));
                }
                case 20: {
                    if (((BArrayType)dataType).getElementType().getTag() == 2) {
                        return new ArrayValueImpl(aggregateString.getBytes(StandardCharsets.UTF_8));
                    }
                    break;
                }
                default: {
                    throw new WebSocketException("Invalid resource signature.");
                }
            }
        }
        catch (WebSocketException ex) {
            webSocketConnection.terminateConnection(1003, ex.detailMessage());
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", ex.getMessage());
        }
        catch (Exception ex) {
            String errorMessage = WebSocketUtil.getErrorMessage(ex);
            if (errorMessage.length() > 123) {
                errorMessage = errorMessage.substring(0, 120) + "...";
            }
            webSocketConnection.terminateConnection(1003, errorMessage);
            log.error("Data binding failed. Hence connection terminated. ", (Throwable)ex);
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", ex.getMessage());
        }
        return null;
    }

    public static void dispatchOnBinary(WebSocketConnectionInfo connectionInfo, WebSocketBinaryMessage binaryMessage) {
        WebSocketObservabilityUtil.observeOnMessage("binary", connectionInfo);
        try {
            WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            AttachedFunction onBinaryMessageResource = wsService.getResourceByName("onBinary");
            if (onBinaryMessageResource == null) {
                webSocketConnection.readNextFrame();
                return;
            }
            BType[] paramDetails = onBinaryMessageResource.getParameterType();
            Object[] bValues = new Object[paramDetails.length * 2];
            bValues[0] = connectionInfo.getWebSocketEndpoint();
            bValues[1] = true;
            bValues[2] = new ArrayValueImpl(binaryMessage.getByteArray());
            bValues[3] = true;
            if (paramDetails.length == 3) {
                bValues[4] = binaryMessage.isFinalFragment();
                bValues[5] = true;
            }
            WebSocketResourceDispatcher.executeResource(wsService, new WebSocketResourceCallback(connectionInfo, "onBinary"), bValues, connectionInfo, "onBinary");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "binary", e.getMessage());
        }
    }

    public static void dispatchOnPingOnPong(WebSocketConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        if (controlMessage.getControlSignal() == WebSocketControlSignal.PING) {
            WebSocketResourceDispatcher.dispatchOnPing(connectionInfo, controlMessage);
        } else if (controlMessage.getControlSignal() == WebSocketControlSignal.PONG) {
            WebSocketResourceDispatcher.dispatchOnPong(connectionInfo, controlMessage);
        }
    }

    private static void dispatchOnPing(WebSocketConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        WebSocketObservabilityUtil.observeOnMessage("ping", connectionInfo);
        try {
            WebSocketService wsService = connectionInfo.getService();
            AttachedFunction onPingMessageResource = wsService.getResourceByName("onPing");
            if (onPingMessageResource == null) {
                WebSocketResourceDispatcher.pongAutomatically(controlMessage);
                return;
            }
            BType[] paramTypes = onPingMessageResource.getParameterType();
            Object[] bValues = new Object[paramTypes.length * 2];
            bValues[0] = connectionInfo.getWebSocketEndpoint();
            bValues[1] = true;
            bValues[2] = new ArrayValueImpl(controlMessage.getByteArray());
            bValues[3] = true;
            WebSocketResourceDispatcher.executeResource(wsService, new WebSocketResourceCallback(connectionInfo, "onPing"), bValues, connectionInfo, "onPing");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "ping", e.getMessage());
        }
    }

    private static void dispatchOnPong(WebSocketConnectionInfo connectionInfo, WebSocketControlMessage controlMessage) {
        WebSocketObservabilityUtil.observeOnMessage("pong", connectionInfo);
        try {
            WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            AttachedFunction onPongMessageResource = wsService.getResourceByName("onPong");
            if (onPongMessageResource == null) {
                webSocketConnection.readNextFrame();
                return;
            }
            BType[] paramDetails = onPongMessageResource.getParameterType();
            Object[] bValues = new Object[paramDetails.length * 2];
            bValues[0] = connectionInfo.getWebSocketEndpoint();
            bValues[1] = true;
            bValues[2] = new ArrayValueImpl(controlMessage.getByteArray());
            bValues[3] = true;
            WebSocketResourceDispatcher.executeResource(wsService, new WebSocketResourceCallback(connectionInfo, "onPong"), bValues, connectionInfo, "onPong");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "pong", e.getMessage());
        }
    }

    public static void dispatchOnClose(final WebSocketConnectionInfo connectionInfo, WebSocketCloseMessage closeMessage) {
        WebSocketObservabilityUtil.observeOnMessage("close", connectionInfo);
        try {
            WebSocketUtil.setListenerOpenField(connectionInfo);
            final WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            AttachedFunction onCloseResource = wsService.getResourceByName("onClose");
            final int closeCode = closeMessage.getCloseCode();
            String closeReason = closeMessage.getCloseReason();
            if (onCloseResource == null) {
                WebSocketResourceDispatcher.finishConnectionClosureIfOpen(webSocketConnection, closeCode, connectionInfo);
                return;
            }
            BType[] paramDetails = onCloseResource.getParameterType();
            Object[] bValues = new Object[paramDetails.length * 2];
            bValues[0] = connectionInfo.getWebSocketEndpoint();
            bValues[1] = true;
            bValues[2] = closeCode;
            bValues[3] = true;
            bValues[4] = closeReason == null ? "" : closeReason;
            bValues[5] = true;
            CallableUnitCallback onCloseCallback = new CallableUnitCallback(){

                public void notifySuccess() {
                    WebSocketResourceDispatcher.finishConnectionClosureIfOpen(webSocketConnection, closeCode, connectionInfo);
                }

                public void notifyFailure(ErrorValue error) {
                    ErrorHandlerUtils.printError((String)error.getPrintableStackTrace());
                    WebSocketResourceDispatcher.finishConnectionClosureIfOpen(webSocketConnection, closeCode, connectionInfo);
                    WebSocketObservabilityUtil.observeError(connectionInfo, "resource_invocation", "onClose", error.getMessage());
                }
            };
            WebSocketResourceDispatcher.executeResource(wsService, onCloseCallback, bValues, connectionInfo, "onClose");
        }
        catch (Exception e) {
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "close", e.getMessage());
        }
    }

    private static void finishConnectionClosureIfOpen(WebSocketConnection webSocketConnection, int closeCode, WebSocketConnectionInfo connectionInfo) {
        if (webSocketConnection.isOpen()) {
            ChannelFuture finishFuture = closeCode == 1005 ? webSocketConnection.finishConnectionClosure() : webSocketConnection.finishConnectionClosure(closeCode, null);
            finishFuture.addListener(closeFuture -> WebSocketUtil.setListenerOpenField(connectionInfo));
        }
    }

    public static void dispatchOnError(final WebSocketConnectionInfo connectionInfo, Throwable throwable) {
        try {
            WebSocketUtil.setListenerOpenField(connectionInfo);
        }
        catch (IllegalAccessException e) {
            connectionInfo.getWebSocketEndpoint().set("open", (Object)false);
        }
        WebSocketService webSocketService = connectionInfo.getService();
        AttachedFunction onErrorResource = webSocketService.getResourceByName("onError");
        if (WebSocketResourceDispatcher.isUnexpectedError(throwable)) {
            log.error("Unexpected error", throwable);
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", "Unexpected error");
        }
        if (onErrorResource == null) {
            ErrorHandlerUtils.printError((Throwable)throwable.getCause());
            return;
        }
        Object[] bValues = new Object[onErrorResource.getParameterType().length * 2];
        bValues[0] = connectionInfo.getWebSocketEndpoint();
        bValues[1] = true;
        bValues[2] = WebSocketUtil.createErrorByType(throwable);
        bValues[3] = true;
        CallableUnitCallback onErrorCallback = new CallableUnitCallback(){

            public void notifySuccess() {
            }

            public void notifyFailure(ErrorValue error) {
                ErrorHandlerUtils.printError((String)error.getPrintableStackTrace());
                WebSocketObservabilityUtil.observeError(connectionInfo, "resource_invocation", "onError", error.getMessage());
            }
        };
        WebSocketResourceDispatcher.executeResource(webSocketService, onErrorCallback, bValues, connectionInfo, "onError");
    }

    private static boolean isUnexpectedError(Throwable throwable) {
        return !(throwable instanceof CorruptedFrameException);
    }

    public static void dispatchOnIdleTimeout(WebSocketConnectionInfo connectionInfo) {
        try {
            final WebSocketConnection webSocketConnection = connectionInfo.getWebSocketConnection();
            WebSocketService wsService = connectionInfo.getService();
            AttachedFunction onIdleTimeoutResource = wsService.getResourceByName("onIdleTimeout");
            if (onIdleTimeoutResource == null) {
                return;
            }
            BType[] paramDetails = onIdleTimeoutResource.getParameterType();
            Object[] bValues = new Object[paramDetails.length * 2];
            bValues[0] = connectionInfo.getWebSocketEndpoint();
            bValues[1] = true;
            CallableUnitCallback onIdleTimeoutCallback = new CallableUnitCallback(){

                public void notifySuccess() {
                }

                public void notifyFailure(ErrorValue error) {
                    ErrorHandlerUtils.printError((String)error.getPrintableStackTrace());
                    WebSocketUtil.closeDuringUnexpectedCondition(webSocketConnection);
                }
            };
            WebSocketResourceDispatcher.executeResource(wsService, onIdleTimeoutCallback, bValues, connectionInfo, "onIdleTimeout");
        }
        catch (Exception e) {
            log.error("Error on idle timeout", (Throwable)e);
            WebSocketObservabilityUtil.observeError(connectionInfo, "message_received", "text", e.getMessage());
        }
    }

    private static void pongAutomatically(WebSocketControlMessage controlMessage) {
        WebSocketConnection webSocketConnection = controlMessage.getWebSocketConnection();
        webSocketConnection.pong(controlMessage.getByteBuffer()).addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                ErrorHandlerUtils.printError((Throwable)cause);
            }
            webSocketConnection.readNextFrame();
        });
    }

    private static void executeResource(WebSocketService wsService, CallableUnitCallback callback, Object[] bValues, WebSocketConnectionInfo connectionInfo, String resource) {
        if (ObserveUtils.isTracingEnabled()) {
            HashMap<String, WebSocketObserverContext> properties = new HashMap<String, WebSocketObserverContext>();
            WebSocketObserverContext observerContext = new WebSocketObserverContext(connectionInfo);
            properties.put("__observer_context__", observerContext);
            Executor.submit((Scheduler)wsService.getScheduler(), (ObjectValue)wsService.getBalService(), (String)resource, (CallableUnitCallback)callback, properties, (Object[])bValues);
        } else {
            Executor.submit((Scheduler)wsService.getScheduler(), (ObjectValue)wsService.getBalService(), (String)resource, (CallableUnitCallback)callback, null, (Object[])bValues);
        }
        WebSocketObservabilityUtil.observeResourceInvocation(connectionInfo, resource);
    }
}

