/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedConnectorListener;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;

public class ClientConnectorListener
implements ExtendedConnectorListener {
    private WebSocketConnectionInfo connectionInfo = null;

    @Override
    public void setConnectionInfo(WebSocketConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        WebSocketResourceDispatcher.dispatchOnText(this.connectionInfo, webSocketTextMessage);
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        WebSocketResourceDispatcher.dispatchOnBinary(this.connectionInfo, webSocketBinaryMessage);
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        WebSocketResourceDispatcher.dispatchOnPingOnPong(this.connectionInfo, webSocketControlMessage);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        WebSocketResourceDispatcher.dispatchOnClose(this.connectionInfo, webSocketCloseMessage);
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        WebSocketResourceDispatcher.dispatchOnError(this.connectionInfo, throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketResourceDispatcher.dispatchOnIdleTimeout(this.connectionInfo);
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        WebSocketObservabilityUtil.observeClose(this.connectionInfo);
        try {
            WebSocketUtil.setListenerOpenField(this.connectionInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }
}

