/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedHandshakeListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;

public class ClientHandshakeListener
implements ExtendedHandshakeListener {
    private ExtendedHandshakeListener handshakeListener;

    public ClientHandshakeListener(ExtendedHandshakeListener handshakeListener) {
        this.handshakeListener = handshakeListener;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse response) {
        this.handshakeListener.onSuccess(webSocketConnection, response);
    }

    public void onError(Throwable throwable, HttpCarbonResponse response) {
        this.handshakeListener.onError(throwable, response);
        WebSocketUtil.countDownForHandshake(this.getWebSocketClient());
        WebSocketResourceDispatcher.dispatchOnError(this.getWebSocketConnectionInfo(), throwable);
    }

    @Override
    public ObjectValue getWebSocketClient() {
        return this.handshakeListener.getWebSocketClient();
    }

    @Override
    public WebSocketConnectionInfo getWebSocketConnectionInfo() {
        return this.handshakeListener.getWebSocketConnectionInfo();
    }
}

