/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client.listener;

import java.util.concurrent.CountDownLatch;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.websocket.WebSocketConstants;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.FailoverContext;
import org.ballerinalang.net.http.websocket.client.RetryContext;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedConnectorListener;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedHandshakeListener;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;

public class WebSocketHandshakeListener
implements ExtendedHandshakeListener {
    private final WebSocketService wsService;
    private final ExtendedConnectorListener connectorListener;
    private final ObjectValue webSocketClient;
    private CountDownLatch countDownLatch;
    private WebSocketConnectionInfo connectionInfo;
    private boolean readyOnConnect;

    public WebSocketHandshakeListener(ObjectValue webSocketClient, WebSocketService wsService, ExtendedConnectorListener connectorListener, CountDownLatch countDownLatch, boolean readyOnConnect) {
        this.webSocketClient = webSocketClient;
        this.wsService = wsService;
        this.connectorListener = connectorListener;
        this.countDownLatch = countDownLatch;
        this.readyOnConnect = readyOnConnect;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse carbonResponse) {
        ObjectValue webSocketConnector;
        this.webSocketClient.set("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)carbonResponse));
        if (this.isFirstConnectionEstablished(this.webSocketClient)) {
            webSocketConnector = (ObjectValue)this.webSocketClient.get("conn");
            this.webSocketClient.set("id", (Object)webSocketConnection.getChannelId());
        } else {
            webSocketConnector = WebSocketHandshakeListener.createWebSocketConnector(this.readyOnConnect);
            WebSocketUtil.populateWebSocketEndpoint(webSocketConnection, this.webSocketClient);
            WebSocketUtil.countDownForHandshake(this.webSocketClient);
        }
        if (this.readyOnConnect) {
            WebSocketUtil.readFirstFrame(webSocketConnection, webSocketConnector);
        }
        this.setWebSocketOpenConnectionInfo(webSocketConnection, webSocketConnector, this.webSocketClient, this.wsService);
        this.connectorListener.setConnectionInfo(this.connectionInfo);
        this.countDownLatch.countDown();
        WebSocketObservabilityUtil.observeConnection(this.connectionInfo);
    }

    public void onError(Throwable t, HttpCarbonResponse response) {
        if (response != null) {
            this.webSocketClient.set("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)response));
        }
        ObjectValue webSocketConnector = BallerinaValues.createObjectValue((BPackage)WebSocketConstants.PROTOCOL_HTTP_PKG_ID, (String)"WebSocketConnector", (Object[])new Object[0]);
        this.setWebSocketOpenConnectionInfo(null, webSocketConnector, this.webSocketClient, this.wsService);
        webSocketConnector.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)this.connectionInfo);
        this.webSocketClient.set("conn", (Object)webSocketConnector);
        this.countDownLatch.countDown();
    }

    @Override
    public ObjectValue getWebSocketClient() {
        return this.webSocketClient;
    }

    @Override
    public WebSocketConnectionInfo getWebSocketConnectionInfo() {
        return this.connectionInfo;
    }

    private void setWebSocketOpenConnectionInfo(WebSocketConnection webSocketConnection, ObjectValue webSocketConnector, ObjectValue webSocketClient, WebSocketService wsService) {
        this.connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketClient);
        webSocketConnector.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)this.connectionInfo);
        webSocketClient.set("conn", (Object)webSocketConnector);
    }

    private static ObjectValue createWebSocketConnector(boolean readyOnConnect) {
        ObjectValue webSocketConnector = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"WebSocketConnector", (Object[])new Object[0]);
        webSocketConnector.set("isReady", (Object)readyOnConnect);
        return webSocketConnector;
    }

    private boolean isFirstConnectionEstablished(ObjectValue webSocketClient) {
        return webSocketClient.getMapValue("config").getMapValue("retryConfig") != null && ((RetryContext)webSocketClient.getNativeData("retryConfig")).isFirstConnectionEstablished() || WebSocketUtil.isFailoverClient(webSocketClient) && ((FailoverContext)webSocketClient.getNativeData("failoverContext")).isFirstConnectionEstablished();
    }
}

