/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.observability;

import java.util.Optional;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;

public class WebSocketTracingUtil {
    static void traceResourceInvocation(Strand strand, WebSocketConnectionInfo connectionInfo) {
        ObserverContext observerContext;
        if (!ObserveUtils.isTracingEnabled()) {
            return;
        }
        Optional observerContextOptional = ObserveUtils.getObserverContextOfCurrentFrame((Strand)strand);
        if (observerContextOptional.isPresent()) {
            observerContext = (ObserverContext)observerContextOptional.get();
        } else {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame((Strand)strand, (ObserverContext)observerContext);
        }
        WebSocketTracingUtil.setTags(observerContext, connectionInfo);
    }

    private static void setTags(ObserverContext observerContext, WebSocketConnectionInfo connectionInfo) {
        observerContext.addTag("client_or_server", WebSocketObservabilityUtil.getClientOrServerContext(connectionInfo));
        observerContext.addTag("service", WebSocketObservabilityUtil.getServicePathOrClientUrl(connectionInfo));
    }

    private WebSocketTracingUtil() {
    }
}

