/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.server;

import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

public class WebSocketConnectionInfo {
    private final WebSocketService webSocketService;
    private final ObjectValue webSocketEndpoint;
    private final WebSocketConnection webSocketConnection;
    private StringAggregator stringAggregator = null;

    public WebSocketConnectionInfo(WebSocketService webSocketService, WebSocketConnection webSocketConnection, ObjectValue webSocketEndpoint) {
        this.webSocketService = webSocketService;
        this.webSocketConnection = webSocketConnection;
        this.webSocketEndpoint = webSocketEndpoint;
    }

    public WebSocketService getService() {
        return this.webSocketService;
    }

    public ObjectValue getWebSocketEndpoint() {
        return this.webSocketEndpoint;
    }

    public WebSocketConnection getWebSocketConnection() throws IllegalAccessException {
        if (this.webSocketConnection != null) {
            return this.webSocketConnection;
        }
        throw new IllegalAccessException("The WebSocket connection has not been made");
    }

    public StringAggregator createIfNullAndGetStringAggregator() {
        if (this.stringAggregator == null) {
            this.stringAggregator = new StringAggregator();
        }
        return this.stringAggregator;
    }

    public static class StringAggregator {
        private String aggregateString = "";

        private StringAggregator() {
        }

        public String getAggregateString() {
            return this.aggregateString;
        }

        public void appendAggregateString(String aggregateString) {
            this.aggregateString = this.aggregateString + aggregateString;
        }

        public void resetAggregateString() {
            this.aggregateString = "";
        }
    }
}

