/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.server;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;

public class WebSocketServerService
extends WebSocketService {
    private String[] negotiableSubProtocols = null;
    private String basePath;
    private int maxFrameSize = 65536;
    private int idleTimeoutInSeconds = 0;
    private HttpResource upgradeResource;

    public WebSocketServerService(ObjectValue service, Scheduler scheduler) {
        super(service, scheduler);
        this.populateConfigs();
    }

    public WebSocketServerService(String httpBasePath, HttpResource upgradeResource, ObjectValue service, Scheduler scheduler) {
        this(service, scheduler);
        this.setBasePathWithUpgradePath(httpBasePath, upgradeResource);
        this.upgradeResource = upgradeResource;
    }

    private void setBasePathWithUpgradePath(String httpBasePath, HttpResource upgradeResource) {
        MapValue resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(upgradeResource.getBalResource());
        MapValue webSocketConfig = resourceConfigAnnotation.getMapValue("webSocketUpgrade");
        String upgradePath = webSocketConfig.getStringValue("upgradePath");
        this.setBasePathToServiceObj(httpBasePath.concat(upgradePath));
    }

    private void populateConfigs() {
        MapValue<String, Object> configAnnotation = this.getServiceConfigAnnotation();
        if (configAnnotation != null) {
            this.negotiableSubProtocols = WebSocketUtil.findNegotiableSubProtocols(configAnnotation);
            this.idleTimeoutInSeconds = WebSocketUtil.findTimeoutInSeconds(configAnnotation, "idleTimeoutInSeconds", 0);
            this.maxFrameSize = WebSocketUtil.findMaxFrameSize(configAnnotation);
        }
        this.setBasePathToServiceObj(this.findFullWebSocketUpgradePath(configAnnotation));
    }

    private MapValue<String, Object> getServiceConfigAnnotation() {
        return (MapValue)this.service.getType().getAnnotation("ballerina/http", "WebSocketServiceConfig");
    }

    public String getName() {
        if (this.service != null) {
            String name = HttpUtil.getServiceName(this.service);
            return name.startsWith("$") ? "" : name;
        }
        return null;
    }

    public String[] getNegotiableSubProtocols() {
        if (this.negotiableSubProtocols == null) {
            return new String[0];
        }
        return (String[])this.negotiableSubProtocols.clone();
    }

    public HttpResource getUpgradeResource() {
        return this.upgradeResource;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setBasePathToServiceObj(String basePath) {
        this.service.addNativeData("BASE_PATH", (Object)basePath);
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    private String findFullWebSocketUpgradePath(MapValue config) {
        String basePathVal;
        String path = null;
        if (config != null && !(basePathVal = config.getStringValue("path")).trim().isEmpty()) {
            path = HttpUtil.sanitizeBasePath(basePathVal);
        }
        if (path == null) {
            path = "/".concat(this.getName());
        }
        return path;
    }
}

