/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.server.WebSocketDataElement;
import org.ballerinalang.net.http.websocket.server.WebSocketDataElementFactory;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.ballerinalang.net.uri.URITemplate;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.Literal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketMessage;

public class WebSocketServicesRegistry {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServicesRegistry.class);
    private URITemplate<WebSocketServerService, WebSocketMessage> uriTemplate;

    public WebSocketServicesRegistry() {
        try {
            this.uriTemplate = new URITemplate<WebSocketServerService, WebSocketMessage>(new Literal<WebSocketServerService, WebSocketMessage>(new WebSocketDataElement(), "/"));
        }
        catch (URITemplateException uRITemplateException) {
            // empty catch block
        }
    }

    public void registerService(WebSocketServerService service) {
        String basePath = service.getBasePath();
        try {
            basePath = URLDecoder.decode(basePath, StandardCharsets.UTF_8.name());
            this.uriTemplate.parse(basePath, service, new WebSocketDataElementFactory());
        }
        catch (UnsupportedEncodingException | URITemplateException e) {
            logger.error("Error when registering service", (Throwable)e);
            throw new WebSocketException(e);
        }
        logger.info("WebSocketService deployed : {} with context {}", (Object)service.getName(), (Object)basePath);
    }

    public WebSocketServerService findMatching(String path, HttpResourceArguments pathParams, WebSocketHandshaker webSocketHandshaker) {
        return this.uriTemplate.matches(path, pathParams, (WebSocketMessage)webSocketHandshaker);
    }

    public WebSocketException unRegisterService(ObjectValue serviceObj) {
        try {
            String basePath = (String)serviceObj.getNativeData("BASE_PATH");
            if (basePath == null) {
                throw new WebSocketException("Cannot detach service. Service has not been registered");
            }
            this.uriTemplate.parse(basePath, null, new WebSocketDataElementFactory());
            serviceObj.addNativeData("BASE_PATH", null);
        }
        catch (UnsupportedEncodingException | URITemplateException e) {
            logger.error("Error when unRegistering service", (Throwable)e);
            return new WebSocketException(e);
        }
        catch (WebSocketException e) {
            return e;
        }
        return null;
    }
}

