/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class URIUtil {
    public static final String URI_PATH_DELIMITER = "/";
    public static final char DOT_SEGMENT = '.';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String[] getPathSegments(String path) {
        if (path.startsWith(URI_PATH_DELIMITER)) {
            path = path.substring(1);
        }
        return path.split(URI_PATH_DELIMITER);
    }

    public static String getSubPath(String path, String basePath) {
        if (path.length() == basePath.length()) {
            return URI_PATH_DELIMITER;
        }
        return path.substring(basePath.length());
    }

    public static void populateQueryParamMap(String queryParamString, MapValue<String, Object> queryParamsMap) throws UnsupportedEncodingException {
        HashMap tempParamMap = new HashMap();
        String[] queryParamVals = queryParamString.split("&");
        for (String queryParam : queryParamVals) {
            int index = queryParam.indexOf(61);
            if (index == -1) continue;
            String queryParamName = queryParam.substring(0, index).trim();
            String queryParamValue = queryParam.substring(index + 1).trim();
            ArrayList<String> values = new ArrayList<String>();
            HashSet<String> uniqueValues = new HashSet<String>();
            for (String val : queryParamValue.split(",")) {
                String decodedValue = URLDecoder.decode(val, "UTF-8");
                if (!uniqueValues.add(decodedValue)) continue;
                values.add(decodedValue);
            }
            if (tempParamMap.containsKey(queryParamName)) {
                ((List)tempParamMap.get(queryParamName)).addAll(values);
                continue;
            }
            tempParamMap.put(queryParamName, values);
        }
        for (Map.Entry entry : tempParamMap.entrySet()) {
            List entryValue = (List)entry.getValue();
            queryParamsMap.put((Object)entry.getKey().toString(), (Object)BValueCreator.createArrayValue((String[])entryValue.toArray(EMPTY_STRING_ARRAY)));
        }
    }

    public static MapValue<String, Object> getMatrixParamsMap(String path, HttpCarbonMessage carbonMessage) {
        MapValueImpl matrixParamsBMap = new MapValueImpl();
        Map pathToMatrixParamMap = (Map)carbonMessage.getProperty("MATRIX_PARAMS");
        Map matrixParamsMap = (Map)pathToMatrixParamMap.get(path);
        if (matrixParamsMap != null) {
            for (Map.Entry matrixParamEntry : matrixParamsMap.entrySet()) {
                matrixParamsBMap.put(matrixParamEntry.getKey(), matrixParamEntry.getValue());
            }
        }
        return matrixParamsBMap;
    }

    public static String extractMatrixParams(String path, Map<String, Map<String, String>> matrixParams) {
        if (path.startsWith(URI_PATH_DELIMITER)) {
            path = path.substring(1);
        }
        String[] pathSplits = path.split("\\?");
        String[] pathSegments = pathSplits[0].split(URI_PATH_DELIMITER);
        String pathToMatrixParam = "";
        for (String pathSegment : pathSegments) {
            String[] splitPathSegment = pathSegment.split(";");
            pathToMatrixParam = pathToMatrixParam.concat(URI_PATH_DELIMITER + splitPathSegment[0]);
            HashMap<String, String> segmentMatrixParams = new HashMap<String, String>();
            for (int i = 1; i < splitPathSegment.length; ++i) {
                String[] splitMatrixParam = splitPathSegment[i].split("=");
                if (splitMatrixParam.length != 2) {
                    throw new BallerinaConnectorException(String.format("Found non-matrix parameter '%s' in path '%s'", splitPathSegment[i], path));
                }
                segmentMatrixParams.put(splitMatrixParam[0], splitMatrixParam[1]);
            }
            matrixParams.put(pathToMatrixParam, segmentMatrixParams);
        }
        for (int i = 1; i < pathSplits.length; ++i) {
            pathToMatrixParam = pathToMatrixParam.concat("?").concat(pathSplits[i]);
        }
        return pathToMatrixParam;
    }
}

