/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri.parser;

import java.util.Map;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.Node;

public class Literal<DataType, InboundMsgType>
extends Node<DataType, InboundMsgType> {
    private int tokenLength;

    public Literal(DataElement<DataType, InboundMsgType> dataElement, String token) throws URITemplateException {
        super(dataElement, token);
        this.tokenLength = token.length();
        if (this.tokenLength == 0) {
            throw new URITemplateException("Invalid literal token with zero length");
        }
    }

    @Override
    String expand(Map<String, String> variables) {
        return this.token;
    }

    @Override
    int match(String uriFragment, HttpResourceArguments variables) {
        if (!this.token.endsWith("*")) {
            if (uriFragment.length() < this.tokenLength) {
                return -1;
            }
            for (int i = 0; i < this.tokenLength; ++i) {
                if (this.token.charAt(i) == uriFragment.charAt(i)) continue;
                if (this.token.charAt(i) == '*' && i == this.token.length() - 1) {
                    return uriFragment.length();
                }
                return -1;
            }
            if (uriFragment.equals("/") && uriFragment.equals(this.token) && !this.dataElement.hasData()) {
                return 0;
            }
            return this.tokenLength;
        }
        if (uriFragment.length() < this.tokenLength - 1) {
            return -1;
        }
        for (int i = 0; i < this.tokenLength - 1; ++i) {
            if (this.token.charAt(i) == uriFragment.charAt(i)) continue;
            if (i == this.token.length() - 1) {
                return uriFragment.length();
            }
            return -1;
        }
        return uriFragment.length();
    }

    @Override
    String getToken() {
        return this.token;
    }

    @Override
    char getFirstCharacter() {
        return this.token.charAt(0);
    }
}

