/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.net.http.HTTPServicesRegistry;
import org.ballerinalang.net.http.HttpCallableUnitCallback;
import org.ballerinalang.net.http.HttpDispatcher;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class BallerinaHTTPConnectorListener
implements HttpConnectorListener {
    private static final Logger log = LoggerFactory.getLogger(BallerinaHTTPConnectorListener.class);
    protected static final String HTTP_RESOURCE = "httpResource";
    private final HTTPServicesRegistry httpServicesRegistry;
    protected final MapValue endpointConfig;

    public BallerinaHTTPConnectorListener(HTTPServicesRegistry httpServicesRegistry, MapValue endpointConfig) {
        this.httpServicesRegistry = httpServicesRegistry;
        this.endpointConfig = endpointConfig;
    }

    public void onMessage(HttpCarbonMessage inboundMessage) {
        try {
            if (this.accessed(inboundMessage)) {
                HttpResource httpResource = (HttpResource)inboundMessage.getProperty(HTTP_RESOURCE);
                this.extractPropertiesAndStartResourceExecution(inboundMessage, httpResource);
                return;
            }
            HttpResource httpResource = HttpDispatcher.findResource(this.httpServicesRegistry, inboundMessage);
            if (HttpDispatcher.shouldDiffer(httpResource)) {
                inboundMessage.setProperty(HTTP_RESOURCE, (Object)httpResource);
                inboundMessage.removeInboundContentListener();
                return;
            }
            try {
                if (httpResource != null) {
                    this.extractPropertiesAndStartResourceExecution(inboundMessage, httpResource);
                }
            }
            catch (BallerinaException ex) {
                HttpUtil.handleFailure(inboundMessage, new BallerinaConnectorException(ex.getMessage(), ex.getCause()));
            }
        }
        catch (Exception ex) {
            HttpUtil.handleFailure(inboundMessage, new BallerinaConnectorException(ex.getMessage(), ex.getCause()));
        }
    }

    public void onError(Throwable throwable) {
        log.warn("Error in HTTP server connector: {}", (Object)throwable.getMessage());
    }

    protected void extractPropertiesAndStartResourceExecution(HttpCarbonMessage inboundMessage, HttpResource httpResource) {
        boolean isTransactionInfectable = httpResource.isTransactionInfectable();
        boolean isInterruptible = httpResource.isInterruptible();
        Map<String, Object> properties = this.collectRequestProperties(inboundMessage, isTransactionInfectable, isInterruptible, httpResource.isTransactionAnnotated());
        Object[] signatureParams = HttpDispatcher.getSignatureParameters(httpResource, inboundMessage, this.endpointConfig);
        if (ObserveUtils.isObservabilityEnabled()) {
            ObserverContext observerContext = new ObserverContext();
            observerContext.setConnectorName("http");
            HashMap httpHeaders = new HashMap();
            inboundMessage.getHeaders().forEach(entry -> {
                String cfr_ignored_0 = (String)httpHeaders.put(entry.getKey(), entry.getValue());
            });
            observerContext.addProperty("trace_properties", httpHeaders);
            observerContext.addTag("http.method", inboundMessage.getHttpMethod());
            observerContext.addTag("protocol", (String)inboundMessage.getProperty("PROTOCOL"));
            observerContext.addTag("http.url", httpResource.getAbsoluteResourcePath());
            observerContext.addTagToSpan("http.url.template", httpResource.getAbsoluteResourcePath());
            observerContext.addTagToSpan("http.url", inboundMessage.getRequestUrl());
            properties.put("__observer_context__", observerContext);
        }
        HttpCallableUnitCallback callback = new HttpCallableUnitCallback(inboundMessage);
        ObjectValue service = httpResource.getParentService().getBalService();
        Executor.submit((Scheduler)this.httpServicesRegistry.getScheduler(), (ObjectValue)service, (String)httpResource.getName(), (CallableUnitCallback)callback, properties, (Object[])signatureParams);
    }

    protected boolean accessed(HttpCarbonMessage inboundMessage) {
        return inboundMessage.getProperty(HTTP_RESOURCE) != null;
    }

    private Map<String, Object> collectRequestProperties(HttpCarbonMessage inboundMessage, boolean isInfectable, boolean isInterruptible, boolean isTransactionAnnotated) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (inboundMessage.getProperty("SRC_HANDLER") != null) {
            Object srcHandler = inboundMessage.getProperty("SRC_HANDLER");
            properties.put("SRC_HANDLER", srcHandler);
        }
        String txnId = inboundMessage.getHeader("x-b7a-xid");
        String registerAtUrl = inboundMessage.getHeader("x-b7a-register-at");
        if (!isInfectable && txnId != null) {
            log.error("Infection attempt on resource with transactionInfectable=false, txnId:" + txnId);
            throw new BallerinaConnectorException("Cannot create transaction context: resource is not transactionInfectable");
        }
        if (isTransactionAnnotated && isInfectable && txnId != null && registerAtUrl != null) {
            properties.put("globalTransactionId", txnId);
            properties.put("transactionUrl", registerAtUrl);
            return properties;
        }
        properties.put("REMOTE_ADDRESS", inboundMessage.getProperty("REMOTE_ADDRESS"));
        properties.put("ORIGIN_HOST", inboundMessage.getHeader("ORIGIN_HOST"));
        properties.put("POOLED_BYTE_BUFFER_FACTORY", inboundMessage.getHeader("POOLED_BYTE_BUFFER_FACTORY"));
        properties.put("b7a.state.interruptible", isInterruptible);
        return properties;
    }
}

