/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.net.http.CorsHeaders;
import org.ballerinalang.net.http.HttpService;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.SignatureParams;
import org.ballerinalang.net.uri.DispatcherUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResource {
    private static final Logger log = LoggerFactory.getLogger(HttpResource.class);
    private static final String METHODS_FIELD = "methods";
    private static final String PATH_FIELD = "path";
    private static final String BODY_FIELD = "body";
    private static final String CONSUMES_FIELD = "consumes";
    private static final String PRODUCES_FIELD = "produces";
    private static final String CORS_FIELD = "cors";
    private static final String TRANSACTION_INFECTABLE_FIELD = "transactionInfectable";
    private AttachedFunction balResource;
    private List<String> methods;
    private String path;
    private String entityBodyAttribute;
    private List<String> consumes;
    private List<String> produces;
    private List<String> producesSubTypes;
    private CorsHeaders corsHeaders;
    private SignatureParams signatureParams;
    private HttpService parentService;
    private boolean transactionInfectable = true;
    private boolean interruptible;
    private boolean transactionAnnotated = false;

    protected HttpResource(AttachedFunction resource, HttpService parentService) {
        this.balResource = resource;
        this.parentService = parentService;
        this.producesSubTypes = new ArrayList<String>();
    }

    public boolean isTransactionAnnotated() {
        return this.transactionAnnotated;
    }

    public String getName() {
        return this.balResource.getName();
    }

    public String getServiceName() {
        return this.balResource.parent.getName();
    }

    public SignatureParams getSignatureParams() {
        return this.signatureParams;
    }

    public HttpService getParentService() {
        return this.parentService;
    }

    public AttachedFunction getBalResource() {
        return this.balResource;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            log.debug("Path not specified in the Resource instance, using default sub path");
            this.path = this.balResource.getName();
        } else {
            this.path = resourcePath;
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
        if (produces != null) {
            List<String> subAttributeValues = produces.stream().map(mediaType -> mediaType.trim().substring(0, mediaType.indexOf(47))).distinct().collect(Collectors.toList());
            this.setProducesSubTypes(subAttributeValues);
        }
    }

    public List<String> getProducesSubTypes() {
        return this.producesSubTypes;
    }

    public void setProducesSubTypes(List<String> producesSubTypes) {
        this.producesSubTypes = producesSubTypes;
    }

    public CorsHeaders getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(CorsHeaders corsHeaders) {
        this.corsHeaders = corsHeaders;
    }

    public boolean isTransactionInfectable() {
        return this.transactionInfectable;
    }

    public void setTransactionInfectable(boolean transactionInfectable) {
        this.transactionInfectable = transactionInfectable;
    }

    public boolean isInterruptible() {
        return this.interruptible;
    }

    public void setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
    }

    public String getEntityBodyAttributeValue() {
        return this.entityBodyAttribute;
    }

    public void setEntityBodyAttributeValue(String entityBodyAttribute) {
        this.entityBodyAttribute = entityBodyAttribute;
    }

    public static HttpResource buildHttpResource(AttachedFunction resource, HttpService httpService) {
        HttpResource httpResource = new HttpResource(resource, httpService);
        MapValue resourceConfigAnnotation = HttpResource.getResourceConfigAnnotation(resource);
        httpResource.setInterruptible(httpService.isInterruptible() || HttpResource.hasInterruptibleAnnotation(resource));
        HttpResource.setupTransactionAnnotations(resource, httpResource);
        if (HttpUtil.checkConfigAnnotationAvailability(resourceConfigAnnotation)) {
            httpResource.setPath(resourceConfigAnnotation.getStringValue(PATH_FIELD).replaceAll("(?<!(http:|https:))//", "/"));
            httpResource.setMethods(HttpResource.getAsStringList(resourceConfigAnnotation.getArrayValue(METHODS_FIELD).getStringArray()));
            httpResource.setConsumes(HttpResource.getAsStringList(resourceConfigAnnotation.getArrayValue(CONSUMES_FIELD).getStringArray()));
            httpResource.setProduces(HttpResource.getAsStringList(resourceConfigAnnotation.getArrayValue(PRODUCES_FIELD).getStringArray()));
            httpResource.setEntityBodyAttributeValue(resourceConfigAnnotation.getStringValue(BODY_FIELD));
            httpResource.setCorsHeaders(CorsHeaders.buildCorsHeaders(resourceConfigAnnotation.getMapValue(CORS_FIELD)));
            httpResource.setTransactionInfectable(resourceConfigAnnotation.getBooleanValue(TRANSACTION_INFECTABLE_FIELD));
            HttpResource.processResourceCors(httpResource, httpService);
            httpResource.prepareAndValidateSignatureParams();
            return httpResource;
        }
        if (log.isDebugEnabled()) {
            log.debug("resourceConfig not specified in the Resource instance, using default sub path");
        }
        httpResource.setPath(resource.getName());
        httpResource.prepareAndValidateSignatureParams();
        return httpResource;
    }

    private static void setupTransactionAnnotations(AttachedFunction resource, HttpResource httpResource) {
        MapValue transactionConfigAnnotation = HttpUtil.getTransactionConfigAnnotation(resource, "ballerina/transactions");
        if (transactionConfigAnnotation != null) {
            httpResource.transactionAnnotated = true;
        }
    }

    public static MapValue getResourceConfigAnnotation(AttachedFunction resource) {
        return (MapValue)resource.getAnnotation("ballerina/http", "ResourceConfig");
    }

    protected static MapValue getPathParamOrderMap(AttachedFunction resource) {
        Object annotation = resource.getAnnotation("ballerina/http", "ParamOrderConfig");
        return annotation == null ? new MapValueImpl() : (MapValue)((MapValue)annotation).get((Object)"pathParamOrder");
    }

    private static boolean hasInterruptibleAnnotation(AttachedFunction resource) {
        return resource.getAnnotation("ballerina/builtin", "interruptible") != null;
    }

    private static List<String> getAsStringList(Object[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Object val : values) {
            valuesList.add(val.toString().trim());
        }
        return !valuesList.isEmpty() ? valuesList : null;
    }

    private static void processResourceCors(HttpResource resource, HttpService service) {
        CorsHeaders corsHeaders = resource.getCorsHeaders();
        if (!corsHeaders.isAvailable()) {
            resource.setCorsHeaders(service.getCorsHeaders());
            return;
        }
        if (corsHeaders.getAllowOrigins() == null) {
            corsHeaders.setAllowOrigins(Stream.of("*").collect(Collectors.toList()));
        }
        if (corsHeaders.getAllowMethods() != null) {
            return;
        }
        if (resource.getMethods() != null) {
            corsHeaders.setAllowMethods(resource.getMethods());
            return;
        }
        corsHeaders.setAllowMethods(DispatcherUtil.addAllMethods());
    }

    private void prepareAndValidateSignatureParams() {
        this.signatureParams = new SignatureParams(this);
        this.signatureParams.validate();
    }

    public List<BType> getParamTypes() {
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        paramTypes.addAll(Arrays.asList(this.balResource.getParameterType()));
        return paramTypes;
    }

    protected String getAbsoluteResourcePath() {
        return (this.parentService.getBasePath() + "/" + this.getPath()).replaceAll("/+", "/");
    }
}

