/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.net.http.CompressionConfigState;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.ValueCreatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;
import org.wso2.transport.http.netty.message.ResponseHandle;

public abstract class AbstractHTTPAction {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTTPAction.class);
    private static final String CACHE_BALLERINA_VERSION = System.getProperty("ballerina.version");
    private static final String WHITESPACE = " ";

    protected static HttpCarbonMessage createOutboundRequestMsg(Strand strand, String serviceUri, MapValue config, String path, ObjectValue request) {
        if (request == null) {
            request = ValueCreatorUtils.createRequestObject();
        }
        HttpCarbonMessage requestMsg = HttpUtil.getCarbonMsg(request, HttpUtil.createHttpCarbonMessage(true));
        HttpUtil.checkEntityAvailability(request);
        HttpUtil.enrichOutboundMessage(requestMsg, request);
        AbstractHTTPAction.prepareOutboundRequest(strand, serviceUri, path, requestMsg, AbstractHTTPAction.isNoEntityBodyRequest(request));
        AbstractHTTPAction.handleAcceptEncodingHeader(requestMsg, AbstractHTTPAction.getCompressionConfigFromEndpointConfig(config));
        return requestMsg;
    }

    static String getCompressionConfigFromEndpointConfig(MapValue clientEndpointConfig) {
        return clientEndpointConfig.get((Object)"compression").toString();
    }

    static void handleAcceptEncodingHeader(HttpCarbonMessage outboundRequest, String compressionConfigValue) {
        CompressionConfigState compressionState = HttpUtil.getCompressionState(compressionConfigValue);
        if (compressionState == CompressionConfigState.ALWAYS && outboundRequest.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) == null) {
            outboundRequest.setHeader(HttpHeaderNames.ACCEPT_ENCODING.toString(), "deflate, gzip");
        } else if (compressionState == CompressionConfigState.NEVER && outboundRequest.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString()) != null) {
            outboundRequest.removeHeader(HttpHeaderNames.ACCEPT_ENCODING.toString());
        }
    }

    static void prepareOutboundRequest(Strand strand, String serviceUri, String path, HttpCarbonMessage outboundRequest, Boolean nonEntityBodyReq) {
        if (strand.isInTransaction()) {
            TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
            outboundRequest.setHeader("x-b7a-xid", transactionLocalContext.getGlobalTransactionId());
            outboundRequest.setHeader("x-b7a-register-at", transactionLocalContext.getURL());
        }
        try {
            String uri = AbstractHTTPAction.getServiceUri(serviceUri) + path;
            URL url = new URL(AbstractHTTPAction.encodeWhitespacesInUri(uri));
            int port = AbstractHTTPAction.getOutboundReqPort(url);
            String host = url.getHost();
            AbstractHTTPAction.setOutboundReqProperties(outboundRequest, url, port, host, nonEntityBodyReq);
            AbstractHTTPAction.setOutboundReqHeaders(outboundRequest, port, host);
        }
        catch (MalformedURLException e) {
            throw HttpUtil.createHttpError("malformed URL specified. " + e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        catch (Exception e) {
            throw HttpUtil.createHttpError("failed to prepare request. " + e.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }

    private static String getServiceUri(String serviceUri) {
        if (serviceUri.isEmpty()) {
            throw HttpUtil.createHttpError("service URI is not defined correctly.", HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        return serviceUri;
    }

    private static String encodeWhitespacesInUri(String uri) {
        if (!uri.contains(WHITESPACE)) {
            return uri;
        }
        return uri.trim().replaceAll(WHITESPACE, "%20");
    }

    private static void setOutboundReqHeaders(HttpCarbonMessage outboundRequest, int port, String host) {
        HttpHeaders headers = outboundRequest.getHeaders();
        AbstractHTTPAction.setHostHeader(host, port, headers);
        AbstractHTTPAction.setOutboundUserAgent(headers);
        AbstractHTTPAction.removeConnectionHeader(headers);
    }

    private static void setOutboundReqProperties(HttpCarbonMessage outboundRequest, URL url, int port, String host, Boolean nonEntityBodyReq) {
        outboundRequest.setProperty("host", (Object)host);
        outboundRequest.setProperty("port", (Object)port);
        String outboundReqPath = AbstractHTTPAction.getOutboundReqPath(url);
        outboundRequest.setProperty("TO", (Object)outboundReqPath);
        outboundRequest.setProperty("PROTOCOL", (Object)url.getProtocol());
        outboundRequest.setProperty("NO_ENTITY_BODY", (Object)nonEntityBodyReq);
    }

    private static void setHostHeader(String host, int port, HttpHeaders headers) {
        if (port == 80 || port == 443) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        } else {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(host + ":" + port));
        }
    }

    private static void removeConnectionHeader(HttpHeaders headers) {
        if (headers.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            headers.remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
    }

    private static void setOutboundUserAgent(HttpHeaders headers) {
        String userAgent = CACHE_BALLERINA_VERSION != null ? "ballerina/" + CACHE_BALLERINA_VERSION : "ballerina";
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)userAgent);
        }
    }

    private static String getOutboundReqPath(URL url) {
        String toPath = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            toPath = toPath + "?" + query;
        }
        return toPath;
    }

    private static int getOutboundReqPort(URL url) {
        int port = 80;
        if (url.getPort() != -1) {
            port = url.getPort();
        } else if (url.getProtocol().equalsIgnoreCase("https")) {
            port = 443;
        }
        return port;
    }

    protected static void executeNonBlockingAction(DataContext dataContext, boolean async) {
        Object remoteAddress;
        Object poolableByteBufferFactory;
        HttpCarbonMessage outboundRequestMsg = dataContext.getOutboundRequest();
        AbstractHTTPAction.checkDirtiness(dataContext, outboundRequestMsg);
        Object sourceHandler = outboundRequestMsg.getProperty("SRC_HANDLER");
        if (sourceHandler == null) {
            outboundRequestMsg.setProperty("SRC_HANDLER", dataContext.getStrand().getProperty("SRC_HANDLER"));
        }
        if ((poolableByteBufferFactory = outboundRequestMsg.getProperty("POOLED_BYTE_BUFFER_FACTORY")) == null) {
            outboundRequestMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", dataContext.getStrand().getProperty("POOLED_BYTE_BUFFER_FACTORY"));
        }
        if ((remoteAddress = outboundRequestMsg.getProperty("REMOTE_ADDRESS")) == null) {
            outboundRequestMsg.setProperty("REMOTE_ADDRESS", dataContext.getStrand().getProperty("REMOTE_ADDRESS"));
        }
        outboundRequestMsg.setProperty("ORIGIN_HOST", dataContext.getStrand().getProperty("ORIGIN_HOST"));
        AbstractHTTPAction.sendOutboundRequest(dataContext, outboundRequestMsg, async);
    }

    private static void checkDirtiness(DataContext dataContext, HttpCarbonMessage outboundRequestMsg) {
        ObjectValue requestObj = dataContext.getRequestObj();
        String contentType = HttpUtil.getContentTypeFromTransportMessage(outboundRequestMsg);
        outboundRequestMsg.setIoException(null);
        if (requestObj != null) {
            if (AbstractHTTPAction.dirty(requestObj)) {
                AbstractHTTPAction.cleanOutboundReq(outboundRequestMsg, requestObj, contentType);
            } else {
                requestObj.set("dirtyRequest", (Object)true);
            }
        }
    }

    private static void cleanOutboundReq(HttpCarbonMessage outboundRequestMsg, ObjectValue request, String contentType) {
        ObjectValue entity = HttpUtil.extractEntity(request);
        if (entity != null) {
            Object messageDataSource = EntityBodyHandler.getMessageDataSource((ObjectValue)entity);
            if (messageDataSource == null && EntityBodyHandler.getByteChannel((ObjectValue)entity) == null && !HeaderUtil.isMultipart((String)contentType)) {
                outboundRequestMsg.addHttpContent((HttpContent)new DefaultLastHttpContent());
            } else {
                outboundRequestMsg.waitAndReleaseAllEntities();
            }
        } else {
            outboundRequestMsg.addHttpContent((HttpContent)new DefaultLastHttpContent());
        }
    }

    static boolean isNoEntityBodyRequest(ObjectValue request) {
        return (Boolean)request.get("noEntityBody");
    }

    private static boolean dirty(ObjectValue request) {
        return (Boolean)request.get("dirtyRequest");
    }

    private static void sendOutboundRequest(DataContext dataContext, HttpCarbonMessage outboundRequestMsg, boolean async) {
        try {
            AbstractHTTPAction.send(dataContext, outboundRequestMsg, async);
        }
        catch (BallerinaConnectorException e) {
            dataContext.notifyInboundResponseStatus(null, HttpUtil.createHttpError(e.getMessage()));
        }
        catch (Exception e) {
            BallerinaException exception = new BallerinaException("Failed to send outboundRequestMsg to the backend", (Throwable)e);
            dataContext.notifyInboundResponseStatus(null, HttpUtil.getError(exception));
        }
    }

    private static void send(DataContext dataContext, HttpCarbonMessage outboundRequestMsg, boolean async) {
        HttpClientConnector clientConnector = dataContext.getClientConnector();
        String contentType = HttpUtil.getContentTypeFromTransportMessage(outboundRequestMsg);
        String boundaryString = null;
        if (HeaderUtil.isMultipart((String)contentType)) {
            boundaryString = HttpUtil.addBoundaryIfNotExist(outboundRequestMsg, contentType);
        }
        HttpUtil.checkAndObserveHttpRequest(dataContext.getStrand(), outboundRequestMsg);
        HTTPClientConnectorListener httpClientConnectorLister = ObserveUtils.isObservabilityEnabled() ? new ObservableHttpClientConnectorListener(dataContext) : new HTTPClientConnectorListener(dataContext);
        HttpMessageDataStreamer outboundMsgDataStreamer = AbstractHTTPAction.getHttpMessageDataStreamer(outboundRequestMsg);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        ObjectValue requestObj = dataContext.getRequestObj();
        ObjectValue entityObj = null;
        if (requestObj != null && (entityObj = HttpUtil.extractEntity(requestObj)) == null) {
            outboundRequestMsg.setPassthrough(true);
        }
        HttpResponseFuture future = clientConnector.send(outboundRequestMsg);
        if (async) {
            future.setResponseHandleListener((HttpClientConnectorListener)httpClientConnectorLister);
        } else {
            future.setHttpConnectorListener((HttpConnectorListener)httpClientConnectorLister);
        }
        try {
            if (entityObj != null) {
                if (boundaryString != null) {
                    AbstractHTTPAction.serializeMultiparts(entityObj, messageOutputStream, boundaryString);
                } else {
                    AbstractHTTPAction.serializeDataSource(entityObj, messageOutputStream);
                }
            }
        }
        catch (EncoderException | IOException serializerException) {
            logger.warn("couldn't serialize the message", serializerException);
        }
        catch (RuntimeException exception) {
            if (exception.getMessage() != null && exception.getMessage().contains("Inbound response message already received")) {
                logger.warn("Response already received before completing the outbound request", (Throwable)exception);
            }
            throw HttpUtil.createHttpError(exception.getMessage(), HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }

    private static HttpMessageDataStreamer getHttpMessageDataStreamer(HttpCarbonMessage outboundRequestMsg) {
        PooledDataStreamerFactory pooledDataStreamerFactory = (PooledDataStreamerFactory)outboundRequestMsg.getProperty("POOLED_BYTE_BUFFER_FACTORY");
        HttpMessageDataStreamer outboundMsgDataStreamer = pooledDataStreamerFactory != null ? pooledDataStreamerFactory.createHttpDataStreamer(outboundRequestMsg) : new HttpMessageDataStreamer(outboundRequestMsg);
        return outboundMsgDataStreamer;
    }

    private static void serializeMultiparts(ObjectValue entityObj, OutputStream messageOutputStream, String boundaryString) throws IOException {
        ArrayValue bodyParts = EntityBodyHandler.getBodyPartArray((ObjectValue)entityObj);
        if (bodyParts != null && bodyParts.size() > 0) {
            AbstractHTTPAction.serializeMultipartDataSource(messageOutputStream, boundaryString, entityObj);
        } else {
            AbstractHTTPAction.serializeDataSource(entityObj, messageOutputStream);
        }
    }

    private static void serializeMultipartDataSource(OutputStream messageOutputStream, String boundaryString, ObjectValue entityObj) {
        MultipartDataSource multipartDataSource = new MultipartDataSource(entityObj, boundaryString);
        multipartDataSource.serialize(messageOutputStream);
        HttpUtil.closeMessageOutputStream(messageOutputStream);
    }

    private static void serializeDataSource(ObjectValue entityObj, OutputStream messageOutputStream) throws IOException {
        Object messageDataSource = EntityBodyHandler.getMessageDataSource((ObjectValue)entityObj);
        if (messageDataSource != null) {
            HttpUtil.serializeDataSource(messageDataSource, entityObj, messageOutputStream);
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        } else if (EntityBodyHandler.getByteChannel((ObjectValue)entityObj) != null) {
            EntityBodyHandler.writeByteChannelToOutputStream((ObjectValue)entityObj, (OutputStream)messageOutputStream);
            HttpUtil.closeMessageOutputStream(messageOutputStream);
        }
    }

    private static class ObservableHttpClientConnectorListener
    extends HTTPClientConnectorListener {
        private final DataContext context;

        private ObservableHttpClientConnectorListener(DataContext dataContext) {
            super(dataContext);
            this.context = dataContext;
        }

        @Override
        public void onMessage(HttpCarbonMessage httpCarbonMessage) {
            super.onMessage(httpCarbonMessage);
            int statusCode = httpCarbonMessage.getHttpStatusCode();
            this.addHttpStatusCode(statusCode);
        }

        @Override
        public void onError(Throwable throwable) {
            super.onError(throwable);
            if (throwable instanceof ClientConnectorException) {
                ClientConnectorException clientConnectorException = (ClientConnectorException)throwable;
                this.addHttpStatusCode(clientConnectorException.getHttpStatusCode());
                Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
                observerContext.ifPresent(ctx -> {
                    ctx.addProperty("error", (Object)Boolean.TRUE);
                    ctx.addProperty("error_message", (Object)throwable.getMessage());
                });
            }
        }

        private void addHttpStatusCode(int statusCode) {
            Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
            observerContext.ifPresent(ctx -> ctx.addTag("http.status_code", String.valueOf(statusCode)));
        }
    }

    private static class HTTPClientConnectorListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        private HTTPClientConnectorListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        public void onMessage(HttpCarbonMessage inboundResponseMessage) {
            this.dataContext.notifyInboundResponseStatus(HttpUtil.createResponseStruct(inboundResponseMessage), null);
        }

        public void onResponseHandle(ResponseHandle responseHandle) {
            ObjectValue httpFuture = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"HttpFuture", (Object[])new Object[0]);
            httpFuture.addNativeData("transport_handle", (Object)responseHandle);
            this.dataContext.notifyInboundResponseStatus(httpFuture, null);
        }

        public void onError(Throwable throwable) {
            ErrorValue httpConnectorError;
            if (throwable instanceof ClientConnectorException) {
                httpConnectorError = HttpUtil.createHttpError(throwable);
            } else if (throwable instanceof IOException) {
                this.dataContext.getOutboundRequest().setIoException((IOException)throwable);
                httpConnectorError = HttpUtil.createHttpError(throwable);
            } else {
                this.dataContext.getOutboundRequest().setIoException(new IOException(throwable.getMessage(), throwable));
                httpConnectorError = HttpUtil.createHttpError(throwable);
            }
            this.dataContext.notifyInboundResponseStatus(null, httpConnectorError);
        }
    }
}

