/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpClientConnectorListener;
import org.wso2.transport.http.netty.message.ResponseHandle;

public class HasPromise
extends AbstractHTTPAction {
    public static boolean hasPromise(ObjectValue clientObj, ObjectValue handleObj) {
        Strand strand = Scheduler.getStrand();
        ResponseHandle responseHandle = (ResponseHandle)handleObj.getNativeData("transport_handle");
        if (responseHandle == null) {
            throw new BallerinaException("invalid http handle");
        }
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        clientConnector.hasPushPromise(responseHandle).setPromiseAvailabilityListener((HttpClientConnectorListener)new PromiseAvailabilityCheckListener(new NonBlockingCallback(strand)));
        return false;
    }

    private static class PromiseAvailabilityCheckListener
    implements HttpClientConnectorListener {
        private NonBlockingCallback callback;

        PromiseAvailabilityCheckListener(NonBlockingCallback callback) {
            this.callback = callback;
        }

        public void onPushPromiseAvailability(boolean isPromiseAvailable) {
            this.callback.setReturnValues((Object)isPromiseAvailable);
            this.callback.notifySuccess();
        }
    }
}

