/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.actions.httpclient;

import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.actions.httpclient.AbstractHTTPAction;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class HttpClientAction
extends AbstractHTTPAction {
    public static Object executeClientAction(ObjectValue httpClient, String path, ObjectValue requestObj, String httpMethod) {
        Strand strand = Scheduler.getStrand();
        String url = httpClient.getStringValue("url");
        MapValue config = (MapValue)httpClient.get("config");
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("Client");
        HttpCarbonMessage outboundRequestMsg = HttpClientAction.createOutboundRequestMsg(strand, url, config, path.replaceAll("(?<!(http:|https:))//", "/"), requestObj);
        outboundRequestMsg.setHttpMethod(httpMethod);
        DataContext dataContext = new DataContext(strand, clientConnector, new NonBlockingCallback(strand), requestObj, outboundRequestMsg);
        HttpClientAction.executeNonBlockingAction(dataContext, false);
        return null;
    }

    public static void rejectPromise(ObjectValue clientObj, ObjectValue pushPromiseObj) {
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, null);
        if (http2PushPromise == null) {
            throw new BallerinaException("invalid push promise");
        }
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        clientConnector.rejectPushResponse(http2PushPromise);
    }
}

