/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.caching;

import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.net.http.caching.CacheControlDirective;

public class CacheControlParser {
    private static final String DIRECTIVE_FORMAT = "\\s*([\\w\\-]+)\\s*(=)?\\s*((\\+|-)?\\d+|\\\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)+\\\")?\\s*";
    private static final Pattern pattern = Pattern.compile("\\s*([\\w\\-]+)\\s*(=)?\\s*((\\+|-)?\\d+|\\\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)+\\\")?\\s*");

    public static Map<CacheControlDirective, String> parse(String cacheControlHeader) {
        EnumMap<CacheControlDirective, String> directivesMap = new EnumMap<CacheControlDirective, String>(CacheControlDirective.class);
        Matcher matcher = pattern.matcher(cacheControlHeader);
        while (matcher.find()) {
            String directiveString = matcher.group(1);
            CacheControlDirective directive = CacheControlDirective.parseValue(directiveString);
            if (directive == CacheControlDirective.INVALID) continue;
            directivesMap.put(directive, matcher.group(3));
        }
        return directivesMap;
    }

    private CacheControlParser() {
    }
}

