/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.compiler;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.ballerinalang.model.tree.expressions.LiteralNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Lists;

public class ResourceSignatureValidator {
    public static final int COMPULSORY_PARAM_COUNT = 2;
    private static final String ENDPOINT_TYPE = "ballerina/http:Listener";
    private static final String CALLER_TYPE = "ballerina/http:Caller";
    private static final String HTTP_REQUEST_TYPE = "ballerina/http:Request";

    public static void validate(FunctionNode resourceNode, DiagnosticLog dlog, DiagnosticPos pos) {
        List signatureParams = resourceNode.getParameters();
        int nParams = signatureParams.size();
        if (nParams < 2) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"resource signature parameter count should be >= 2");
            return;
        }
        if (!ResourceSignatureValidator.isValidResourceParam((BLangSimpleVariable)signatureParams.get(0), CALLER_TYPE)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"first parameter should be of type ballerina/http:Caller");
            return;
        }
        if (!ResourceSignatureValidator.isValidResourceParam((BLangSimpleVariable)signatureParams.get(1), HTTP_REQUEST_TYPE)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"second parameter should be of type ballerina/http:Request");
        }
        ResourceSignatureValidator.validateResourceAnnotation(resourceNode, dlog);
    }

    private static boolean isValidResourceParam(BLangSimpleVariable param, String expectedType) {
        return expectedType.equals(param.type.toString());
    }

    static void validateResourceAnnotation(FunctionNode resourceNode, DiagnosticLog dlog) {
        List annotations = resourceNode.getAnnotationAttachments();
        ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> annVals = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
        ArrayList<String> paramSegments = new ArrayList<String>();
        int count = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ResourceConfig") || annotation.getExpression() == null) continue;
            for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)annotation.getExpression()).fields) {
                annVals.add((BLangRecordLiteral.BLangRecordKeyValueField)field);
            }
            ++count;
        }
        if (count != 1) {
            return;
        }
        for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : annVals) {
            switch (ResourceSignatureValidator.getAnnotationFieldKey(keyValue)) {
                case "webSocketUpgrade": {
                    ResourceSignatureValidator.validateWebSocketUpgrade(resourceNode, dlog, annVals, paramSegments, keyValue);
                    break;
                }
                case "path": {
                    ResourceSignatureValidator.validateResourcePath(dlog, paramSegments, keyValue);
                    break;
                }
                case "body": {
                    List parameters = resourceNode.getParameters();
                    String bodyFieldValue = "";
                    BLangExpression valueExpr = keyValue.getValue();
                    if (valueExpr instanceof LiteralNode) {
                        LiteralNode literal = (LiteralNode)valueExpr;
                        bodyFieldValue = literal.getValue().toString();
                    }
                    String signatureBodyParam = ((SimpleVariableNode)parameters.get(parameters.size() - 1)).getName().getValue();
                    if (bodyFieldValue.isEmpty()) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)keyValue.getValue().getPosition(), (CharSequence)"Empty data binding param value");
                    } else if (!signatureBodyParam.equals(bodyFieldValue)) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)keyValue.getValue().getPosition(), (CharSequence)("Invalid data binding param in the signature : expected '" + bodyFieldValue + "', but found '" + signatureBodyParam + "'"));
                    }
                    paramSegments.add(bodyFieldValue);
                    break;
                }
            }
        }
        ResourceSignatureValidator.verifySignatureParamsWithAnnotatedParams(resourceNode, dlog, paramSegments);
    }

    private static void validateWebSocketUpgrade(FunctionNode resourceNode, DiagnosticLog dlog, List<BLangRecordLiteral.BLangRecordKeyValueField> annVals, List<String> paramSegments, BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        if (annVals.size() > 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"Invalid configurations for WebSocket upgrade resource");
            return;
        }
        ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> upgradeFields = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
        for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)keyValue.valueExpr).fields) {
            upgradeFields.add((BLangRecordLiteral.BLangRecordKeyValueField)field);
        }
        if (upgradeFields.isEmpty()) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"An upgradeService need to be specified for the WebSocket upgrade resource");
            return;
        }
        if (upgradeFields.size() == 1 && !ResourceSignatureValidator.getAnnotationFieldKey((BLangRecordLiteral.BLangRecordKeyValueField)upgradeFields.get(0)).equals("upgradeService")) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)"An upgradeService need to be specified for the WebSocket upgrade resource");
            return;
        }
        for (BLangRecordLiteral.BLangRecordKeyValueField upgradeField : upgradeFields) {
            if (!ResourceSignatureValidator.getAnnotationFieldKey(upgradeField).equals("upgradePath")) continue;
            ResourceSignatureValidator.validateResourcePath(dlog, paramSegments, upgradeField);
        }
    }

    private static void validateResourcePath(DiagnosticLog dlog, List<String> paramSegments, BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        DiagnosticPos position = keyValue.getValue().getPosition();
        List segments = new ArrayList();
        BLangExpression valueExpr = keyValue.getValue();
        if (valueExpr instanceof LiteralNode) {
            LiteralNode literal = (LiteralNode)valueExpr;
            segments = Lists.of((Object[])literal.getValue().toString().split("/"));
        }
        for (String segment : segments) {
            ResourceSignatureValidator.validatePathSegment(segment, position, dlog, paramSegments);
        }
    }

    private static void validatePathSegment(String segment, DiagnosticPos pos, DiagnosticLog dlog, List<String> pathParamSegments) {
        boolean expression = false;
        int startIndex = 0;
        int maxIndex = segment.length() - 1;
        block4: for (int pointerIndex = 0; pointerIndex < segment.length(); ++pointerIndex) {
            char ch = segment.charAt(pointerIndex);
            switch (ch) {
                case '{': {
                    if (expression) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Illegal open brace character in resource path config");
                        continue block4;
                    }
                    if (pointerIndex + 1 >= maxIndex) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Invalid param expression in resource path config");
                    }
                    if (pointerIndex != startIndex) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Illegal expression in resource path config");
                    }
                    expression = true;
                    ++startIndex;
                    continue block4;
                }
                case '}': {
                    if (!expression) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Illegal closing brace detected in resource path config");
                        continue block4;
                    }
                    if (pointerIndex <= startIndex) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Illegal empty expression in resource path config");
                    }
                    pathParamSegments.add(segment.substring(startIndex, pointerIndex));
                    expression = false;
                    startIndex = pointerIndex + 1;
                    continue block4;
                }
                default: {
                    if (pointerIndex != maxIndex) continue block4;
                    if (expression) {
                        dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Incomplete path param expression");
                        continue block4;
                    }
                    if (startIndex == 0 || pointerIndex != startIndex) continue block4;
                    dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"Illegal expression in resource path config");
                }
            }
        }
    }

    private static void verifySignatureParamsWithAnnotatedParams(FunctionNode resourceNode, DiagnosticLog dlog, List<String> paramSegments) {
        List signatureParams = resourceNode.getParameters().subList(2, resourceNode.getParameters().size());
        if (!signatureParams.stream().allMatch(signatureParam -> paramSegments.stream().anyMatch(parameter -> signatureParam.getName().getValue().equals(parameter)))) {
            String errorMsg = "invalid resource parameter(s): cannot specify > 2 parameters without specifying path config and/or body config in the resource annotation";
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, resourceNode.getPosition(), (CharSequence)errorMsg);
        }
    }

    private ResourceSignatureValidator() {
    }

    private static String getAnnotationFieldKey(BLangRecordLiteral.BLangRecordKeyValueField keyValue) {
        return ((BLangSimpleVarRef)keyValue.key.expr).variableName.getValue();
    }
}

