/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import java.io.OutputStream;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.nativeimpl.connection.ConnectionAction;
import org.ballerinalang.net.http.nativeimpl.connection.ResponseWriter;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class PushPromisedResponse
extends ConnectionAction {
    public static Object pushPromisedResponse(ObjectValue connectionObj, ObjectValue pushPromiseObj, ObjectValue outboundResponseObj) {
        HttpCarbonMessage inboundRequestMsg = HttpUtil.getCarbonMsg(connectionObj, null);
        Strand strand = Scheduler.getStrand();
        DataContext dataContext = new DataContext(strand, new NonBlockingCallback(strand), inboundRequestMsg);
        HttpUtil.serverConnectionStructCheck(inboundRequestMsg);
        Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, null);
        if (http2PushPromise == null) {
            throw BallerinaErrors.createError((String)"invalid push promise");
        }
        HttpCarbonMessage outboundResponseMsg = HttpUtil.getCarbonMsg(outboundResponseObj, HttpUtil.createHttpCarbonMessage(false));
        HttpUtil.prepareOutboundResponse(connectionObj, inboundRequestMsg, outboundResponseMsg, outboundResponseObj);
        PushPromisedResponse.pushResponseRobust(dataContext, inboundRequestMsg, outboundResponseObj, outboundResponseMsg, http2PushPromise);
        return null;
    }

    private static void pushResponseRobust(DataContext dataContext, HttpCarbonMessage requestMessage, ObjectValue outboundResponseObj, HttpCarbonMessage responseMessage, Http2PushPromise http2PushPromise) {
        HttpResponseFuture outboundRespStatusFuture = HttpUtil.pushResponse(requestMessage, responseMessage, http2PushPromise);
        HttpMessageDataStreamer outboundMsgDataStreamer = PushPromisedResponse.getMessageDataStreamer(responseMessage);
        ResponseWriter.HttpResponseConnectorListener outboundResStatusConnectorListener = new ResponseWriter.HttpResponseConnectorListener(dataContext, outboundMsgDataStreamer);
        outboundRespStatusFuture.setHttpConnectorListener((HttpConnectorListener)outboundResStatusConnectorListener);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        ObjectValue entityObj = HttpUtil.extractEntity(outboundResponseObj);
        if (entityObj != null) {
            Object outboundMessageSource = EntityBodyHandler.getMessageDataSource((ObjectValue)entityObj);
            PushPromisedResponse.serializeMsgDataSource(outboundMessageSource, entityObj, messageOutputStream);
        }
    }
}

