/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.nativeimpl.connection;

import java.io.IOException;
import java.io.OutputStream;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.mime.util.EntityBodyHandler;
import org.ballerinalang.mime.util.HeaderUtil;
import org.ballerinalang.mime.util.MultipartDataSource;
import org.ballerinalang.net.http.DataContext;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public class ResponseWriter {
    public static void sendResponseRobust(DataContext dataContext, HttpCarbonMessage requestMessage, ObjectValue outboundResponse, HttpCarbonMessage responseMessage) {
        String contentType = HttpUtil.getContentTypeFromTransportMessage(responseMessage);
        String boundaryString = null;
        if (HeaderUtil.isMultipart((String)contentType)) {
            boundaryString = HttpUtil.addBoundaryIfNotExist(responseMessage, contentType);
        }
        HttpMessageDataStreamer outboundMsgDataStreamer = ResponseWriter.getResponseDataStreamer(responseMessage);
        ObjectValue entityObj = HttpUtil.extractEntity(outboundResponse);
        if (entityObj == null) {
            responseMessage.setPassthrough(true);
        }
        HttpResponseFuture outboundRespStatusFuture = HttpUtil.sendOutboundResponse(requestMessage, responseMessage);
        HttpResponseConnectorListener outboundResStatusConnectorListener = new HttpResponseConnectorListener(dataContext, outboundMsgDataStreamer);
        outboundRespStatusFuture.setHttpConnectorListener((HttpConnectorListener)outboundResStatusConnectorListener);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        if (entityObj != null) {
            if (boundaryString != null) {
                ResponseWriter.serializeMultiparts(boundaryString, entityObj, messageOutputStream);
            } else {
                Object outboundMessageSource = EntityBodyHandler.getMessageDataSource((ObjectValue)entityObj);
                ResponseWriter.serializeDataSource(outboundMessageSource, entityObj, messageOutputStream);
            }
        }
    }

    private static void serializeMultiparts(String boundaryString, ObjectValue entity, OutputStream messageOutputStream) {
        ArrayValue bodyParts = EntityBodyHandler.getBodyPartArray((ObjectValue)entity);
        try {
            if (bodyParts != null && bodyParts.size() > 0) {
                MultipartDataSource multipartDataSource = new MultipartDataSource(entity, boundaryString);
                ResponseWriter.serializeDataSource(multipartDataSource, entity, messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            } else {
                EntityBodyHandler.writeByteChannelToOutputStream((ObjectValue)entity, (OutputStream)messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            }
        }
        catch (IOException ex) {
            throw BallerinaErrors.createError((String)"{ballerina/mime}SerializationError", (String)("error occurred while serializing byte channel content : " + ex.getMessage()));
        }
    }

    static void serializeDataSource(Object outboundMessageSource, ObjectValue entity, OutputStream messageOutputStream) {
        try {
            if (outboundMessageSource != null) {
                HttpUtil.serializeDataSource(outboundMessageSource, entity, messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            } else {
                EntityBodyHandler.writeByteChannelToOutputStream((ObjectValue)entity, (OutputStream)messageOutputStream);
                HttpUtil.closeMessageOutputStream(messageOutputStream);
            }
        }
        catch (IOException ex) {
            throw BallerinaErrors.createError((String)"{ballerina/mime}SerializationError", (String)("error occurred while serializing message data source : " + ex.getMessage()));
        }
    }

    static HttpMessageDataStreamer getResponseDataStreamer(HttpCarbonMessage outboundResponse) {
        PooledDataStreamerFactory pooledDataStreamerFactory = (PooledDataStreamerFactory)outboundResponse.getProperty("POOLED_BYTE_BUFFER_FACTORY");
        HttpMessageDataStreamer outboundMsgDataStreamer = pooledDataStreamerFactory != null ? pooledDataStreamerFactory.createHttpDataStreamer(outboundResponse) : new HttpMessageDataStreamer(outboundResponse);
        return outboundMsgDataStreamer;
    }

    static class HttpResponseConnectorListener
    implements HttpConnectorListener {
        private final DataContext dataContext;
        private HttpMessageDataStreamer outboundMsgDataStreamer;

        HttpResponseConnectorListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        HttpResponseConnectorListener(DataContext dataContext, HttpMessageDataStreamer outboundMsgDataStreamer) {
            this.dataContext = dataContext;
            this.outboundMsgDataStreamer = outboundMsgDataStreamer;
        }

        public void onMessage(HttpCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyOutboundResponseStatus(null);
        }

        public void onError(Throwable throwable) {
            ErrorValue httpConnectorError = HttpUtil.createHttpError(throwable.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
            if (this.outboundMsgDataStreamer != null && !(throwable instanceof IOException)) {
                this.dataContext.getOutboundRequest().setIoException(new IOException(throwable.getMessage(), throwable));
            }
            this.dataContext.notifyOutboundResponseStatus(httpConnectorError);
        }
    }
}

