/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket;

import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BError;
import org.ballerinalang.jvm.values.connector.NonBlockingCallback;
import org.ballerinalang.net.http.HttpConstants;
import org.ballerinalang.net.http.HttpErrorType;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.websocket.WebSocketConstants;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.client.FailoverContext;
import org.ballerinalang.net.http.websocket.client.RetryContext;
import org.ballerinalang.net.http.websocket.client.listener.ClientHandshakeListener;
import org.ballerinalang.net.http.websocket.client.listener.ExtendedConnectorListener;
import org.ballerinalang.net.http.websocket.client.listener.FailoverHandshakeListener;
import org.ballerinalang.net.http.websocket.client.listener.RetryHandshakeListener;
import org.ballerinalang.net.http.websocket.client.listener.WebSocketHandshakeListener;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionManager;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.ballerinalang.stdlib.io.utils.IOConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.config.SslConfiguration;
import org.wso2.transport.http.netty.contract.websocket.ClientHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnectorConfig;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;

public class WebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketUtil.class);
    private static final String CLIENT_ENDPOINT_CONFIG = "config";
    private static final String HANDSHAKE_TIME_OUT = "handShakeTimeoutInSeconds";
    private static final String WEBSOCKET_FAILOVER_CLIENT_NAME = "http:WebSocketFailoverClient";
    public static final String ERROR_MESSAGE = "Error occurred: ";
    public static final String LOG_MESSAGE = "{} {}";

    public static ObjectValue createAndPopulateWebSocketCaller(WebSocketConnection webSocketConnection, WebSocketServerService wsService, WebSocketConnectionManager connectionManager) {
        ObjectValue webSocketCaller = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"WebSocketCaller", (Object[])new Object[0]);
        ObjectValue webSocketConnector = BallerinaValues.createObjectValue((BPackage)HttpConstants.PROTOCOL_HTTP_PKG_ID, (String)"WebSocketConnector", (Object[])new Object[0]);
        webSocketCaller.set("conn", (Object)webSocketConnector);
        WebSocketUtil.populateWebSocketEndpoint(webSocketConnection, webSocketCaller);
        WebSocketConnectionInfo connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketCaller);
        connectionManager.addConnection(webSocketConnection.getChannelId(), connectionInfo);
        webSocketConnector.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)connectionInfo);
        WebSocketObservabilityUtil.observeConnection(connectionManager.getConnectionInfo(webSocketConnection.getChannelId()));
        return webSocketCaller;
    }

    public static void populateWebSocketEndpoint(WebSocketConnection webSocketConnection, ObjectValue webSocketClient) {
        webSocketClient.set("id", (Object)webSocketConnection.getChannelId());
        String negotiatedSubProtocol = webSocketConnection.getNegotiatedSubProtocol();
        webSocketClient.set("negotiatedSubProtocol", (Object)negotiatedSubProtocol);
        webSocketClient.set("secure", (Object)webSocketConnection.isSecure());
        webSocketClient.set("open", (Object)webSocketConnection.isOpen());
    }

    public static void handleWebSocketCallback(NonBlockingCallback callback, ChannelFuture webSocketChannelFuture, Logger log, WebSocketConnectionInfo connectionInfo) {
        webSocketChannelFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (!future.isSuccess() && cause != null) {
                log.error(ERROR_MESSAGE, cause);
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, callback, cause);
            } else {
                callback.setReturnValues(null);
                callback.notifySuccess();
            }
        });
    }

    public static void setCallbackFunctionBehaviour(WebSocketConnectionInfo connectionInfo, NonBlockingCallback callback, Throwable error) {
        if (WebSocketUtil.hasSupportForResiliency(connectionInfo)) {
            ErrorHandlerUtils.printError((Throwable)error);
            callback.notifySuccess();
        } else {
            callback.notifyFailure((BError)WebSocketUtil.createErrorByType(error));
        }
    }

    private static boolean hasSupportForResiliency(WebSocketConnectionInfo connectionInfo) {
        return connectionInfo.getWebSocketEndpoint().getType().getName().equalsIgnoreCase("WebSocketClient") && WebSocketUtil.hasRetryContext(connectionInfo.getWebSocketEndpoint()) || connectionInfo.getWebSocketEndpoint().getType().getName().equalsIgnoreCase("WebSocketFailoverClient");
    }

    public static void readFirstFrame(WebSocketConnection webSocketConnection, ObjectValue wsConnector) {
        webSocketConnection.readNextFrame();
        wsConnector.set("isReady", (Object)true);
    }

    public static void closeDuringUnexpectedCondition(WebSocketConnection webSocketConnection) {
        webSocketConnection.terminateConnection(1011, "Unexpected condition");
    }

    public static void setListenerOpenField(WebSocketConnectionInfo connectionInfo) throws IllegalAccessException {
        connectionInfo.getWebSocketEndpoint().set("open", (Object)connectionInfo.getWebSocketConnection().isOpen());
    }

    public static int findMaxFrameSize(MapValue<String, Object> configs) {
        long size = configs.getIntValue("maxFrameSize");
        if (size <= 0L) {
            return 65536;
        }
        try {
            return Math.toIntExact(size);
        }
        catch (ArithmeticException e) {
            logger.warn("The value set for maxFrameSize needs to be less than 2147483647. The maxFrameSize value is set to 2147483647");
            return Integer.MAX_VALUE;
        }
    }

    public static int findTimeoutInSeconds(MapValue<String, Object> config, String key, int defaultValue) {
        long timeout = config.getIntValue(key);
        if (timeout < 0L) {
            return defaultValue;
        }
        try {
            return Math.toIntExact(timeout);
        }
        catch (ArithmeticException e) {
            logger.warn("The value set for {} needs to be less than {} .The {} value is set to {} ", new Object[]{key, Integer.MAX_VALUE, key, Integer.MAX_VALUE});
            return Integer.MAX_VALUE;
        }
    }

    public static String[] findNegotiableSubProtocols(MapValue<String, Object> configs) {
        return configs.getArrayValue("subProtocols").getStringArray();
    }

    static String getErrorMessage(Throwable err) {
        if (err.getMessage() == null) {
            return "Unexpected error occurred";
        }
        return err.getMessage();
    }

    public static WebSocketException createErrorByType(Throwable throwable) {
        if (throwable instanceof WebSocketException) {
            return (WebSocketException)((Object)throwable);
        }
        WebSocketConstants.ErrorCode errorCode = WebSocketConstants.ErrorCode.WsGenericError;
        ErrorValue cause = null;
        String message = WebSocketUtil.getErrorMessage(throwable);
        if (throwable instanceof CorruptedWebSocketFrameException) {
            WebSocketCloseStatus status = ((CorruptedWebSocketFrameException)throwable).closeStatus();
            errorCode = status == WebSocketCloseStatus.MESSAGE_TOO_BIG ? WebSocketConstants.ErrorCode.WsPayloadTooBigError : WebSocketConstants.ErrorCode.WsProtocolError;
        } else if (throwable instanceof SSLException) {
            cause = WebSocketUtil.createErrorCause(throwable.getMessage(), HttpErrorType.SSL_ERROR.getReason(), WebSocketConstants.PROTOCOL_HTTP_PKG_ID);
            message = "SSL/TLS Error";
        } else if (throwable instanceof IllegalStateException) {
            if (throwable.getMessage().contains("frame continuation")) {
                errorCode = WebSocketConstants.ErrorCode.WsInvalidContinuationFrameError;
            } else if (throwable.getMessage().toLowerCase(Locale.ENGLISH).contains("close frame")) {
                errorCode = WebSocketConstants.ErrorCode.WsConnectionClosureError;
            }
        } else if (throwable instanceof IllegalAccessException && throwable.getMessage().equals("The WebSocket connection has not been made")) {
            errorCode = WebSocketConstants.ErrorCode.WsConnectionError;
            if (throwable.getMessage() == null) {
                message = "The WebSocket connection has not been made";
            }
        } else if (throwable instanceof TooLongFrameException) {
            errorCode = WebSocketConstants.ErrorCode.WsPayloadTooBigError;
        } else if (throwable instanceof CodecException) {
            errorCode = WebSocketConstants.ErrorCode.WsProtocolError;
        } else if (throwable instanceof WebSocketHandshakeException) {
            errorCode = WebSocketConstants.ErrorCode.WsInvalidHandshakeError;
        } else if (throwable instanceof IOException) {
            errorCode = WebSocketConstants.ErrorCode.WsConnectionError;
            cause = WebSocketUtil.createErrorCause(throwable.getMessage(), IOConstants.ErrorCode.GenericError.errorCode(), IOConstants.IO_PACKAGE_ID);
            message = "IO Error";
        }
        return new WebSocketException(errorCode, message, cause);
    }

    private static ErrorValue createErrorCause(String message, String reason, BPackage packageName) {
        MapValue detailRecordType = BallerinaValues.createRecordValue((BPackage)packageName, (String)"Detail");
        MapValue detailRecord = BallerinaValues.createRecord((MapValue)detailRecordType, (Object[])new Object[]{message, null});
        return BallerinaErrors.createError((String)reason, (MapValue)detailRecord);
    }

    public static boolean reconnect(ObjectValue webSocketClient, WebSocketService wsService) {
        RetryContext retryConnectorConfig = (RetryContext)webSocketClient.getNativeData("retryConfig");
        int maxAttempts = retryConnectorConfig.getMaxAttempts();
        int noOfReconnectAttempts = retryConnectorConfig.getReconnectAttempts();
        if (noOfReconnectAttempts < maxAttempts || maxAttempts == 0) {
            retryConnectorConfig.setReconnectAttempts(noOfReconnectAttempts + 1);
            if (logger.isDebugEnabled()) {
                Date date = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                String time = formatter.format(date.getTime());
                logger.debug(LOG_MESSAGE, (Object)time, (Object)"reconnecting...");
            }
            WebSocketUtil.createDelay(WebSocketUtil.calculateWaitingTime(retryConnectorConfig.getInterval(), retryConnectorConfig.getMaxInterval(), retryConnectorConfig.getBackOfFactor(), noOfReconnectAttempts));
            WebSocketUtil.establishWebSocketConnection((WebSocketClientConnector)webSocketClient.getNativeData("clientConnector"), webSocketClient, wsService);
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(LOG_MESSAGE, (Object)"Maximum retry attempts but couldn't connect to the server: ", (Object)webSocketClient.getStringValue("url"));
        }
        return false;
    }

    public static boolean failover(ObjectValue webSocketClient, WebSocketService wsService) {
        FailoverContext failoverContext = (FailoverContext)webSocketClient.getNativeData("failoverContext");
        int currentIndex = failoverContext.getCurrentIndex();
        List<String> targets = failoverContext.getTargetUrls();
        if (++currentIndex == targets.size()) {
            currentIndex = 0;
        }
        if (currentIndex != failoverContext.getInitialIndex()) {
            failoverContext.setCurrentIndex(currentIndex);
            WebSocketUtil.createDelay(failoverContext.getFailoverInterval());
            WebSocketUtil.establishWebSocketConnection(WebSocketUtil.createWebSocketClientConnector(targets.get(currentIndex).toString(), webSocketClient), webSocketClient, wsService);
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(LOG_MESSAGE, (Object)"Couldn't connect to one of the server in the targets: ", targets);
        }
        return false;
    }

    public static void establishWebSocketConnection(WebSocketClientConnector clientConnector, ObjectValue webSocketClient, WebSocketService wsService) {
        boolean readyOnConnect = webSocketClient.getMapValue(CLIENT_ENDPOINT_CONFIG).getBooleanValue("readyOnConnect");
        ClientHandshakeFuture handshakeFuture = clientConnector.connect();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        WebSocketUtil.setListenersToHandshakeFuture(handshakeFuture, webSocketClient, wsService, countDownLatch, readyOnConnect);
        WebSocketUtil.waitForHandshake(webSocketClient, countDownLatch, wsService);
    }

    private static void setListenersToHandshakeFuture(ClientHandshakeFuture handshakeFuture, ObjectValue webSocketClient, WebSocketService wsService, CountDownLatch countDownLatch, boolean readyOnConnect) {
        ExtendedConnectorListener connectorListener = (ExtendedConnectorListener)webSocketClient.getNativeData("clientListener");
        handshakeFuture.setWebSocketConnectorListener((WebSocketConnectorListener)connectorListener);
        WebSocketHandshakeListener webSocketHandshakeListener = new WebSocketHandshakeListener(webSocketClient, wsService, connectorListener, countDownLatch, readyOnConnect);
        if (WebSocketUtil.hasRetryContext(webSocketClient)) {
            handshakeFuture.setClientHandshakeListener((org.wso2.transport.http.netty.contract.websocket.ClientHandshakeListener)new RetryHandshakeListener(webSocketHandshakeListener, (RetryContext)webSocketClient.getNativeData("retryConfig"), wsService));
        } else if (WebSocketUtil.isFailoverClient(webSocketClient)) {
            handshakeFuture.setClientHandshakeListener((org.wso2.transport.http.netty.contract.websocket.ClientHandshakeListener)new FailoverHandshakeListener(webSocketHandshakeListener, wsService));
        } else {
            handshakeFuture.setClientHandshakeListener((org.wso2.transport.http.netty.contract.websocket.ClientHandshakeListener)new ClientHandshakeListener(webSocketHandshakeListener));
        }
    }

    public static boolean hasRetryContext(ObjectValue webSocketClient) {
        return webSocketClient.getMapValue(CLIENT_ENDPOINT_CONFIG).getMapValue("retryConfig") != null;
    }

    public static boolean isFailoverClient(ObjectValue webSocketClient) {
        return webSocketClient.getType().getName().equalsIgnoreCase("WebSocketFailoverClient");
    }

    private static void waitForHandshake(ObjectValue webSocketClient, CountDownLatch countDownLatch, WebSocketService wsService) {
        block4: {
            long timeout = WebSocketUtil.findTimeoutInSeconds((MapValue<String, Object>)webSocketClient.getMapValue(CLIENT_ENDPOINT_CONFIG), HANDSHAKE_TIME_OUT, 300);
            try {
                if (countDownLatch.await(timeout, TimeUnit.SECONDS)) break block4;
                countDownLatch.countDown();
                if (WebSocketUtil.hasRetryContext(webSocketClient)) {
                    WebSocketUtil.reconnect(webSocketClient, wsService);
                    break block4;
                }
                if (WebSocketUtil.isFailoverClient(webSocketClient)) {
                    WebSocketUtil.failover(webSocketClient, wsService);
                    break block4;
                }
                throw new WebSocketException(WebSocketConstants.ErrorCode.WsInvalidHandshakeError, "Waiting for WebSocket handshake has not been successful", WebSocketUtil.createErrorCause("Connection timeout", IOConstants.ErrorCode.ConnectionTimedOut.errorCode(), IOConstants.IO_PACKAGE_ID));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebSocketException(ERROR_MESSAGE + e.getMessage());
            }
        }
    }

    private static void createDelay(int interval) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            if (!countDownLatch.await(interval, TimeUnit.MILLISECONDS)) {
                countDownLatch.countDown();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebSocketException(ERROR_MESSAGE + e.getMessage());
        }
    }

    private static int calculateWaitingTime(int interval, int maxInterval, double backOfFactor, int reconnectAttempts) {
        if ((interval = (int)((double)interval * Math.pow(backOfFactor, reconnectAttempts))) > maxInterval) {
            interval = maxInterval;
        }
        return interval;
    }

    public static int getIntValue(MapValue<String, Object> configs, String key, int defaultValue) {
        int value = Math.toIntExact(configs.getIntValue(key));
        if (value < 0) {
            logger.warn("The value set for `{}` needs to be great than than -1. The `{}` value is set to {}", new Object[]{key, key, defaultValue});
            value = defaultValue;
        }
        return value;
    }

    public static void populateClientConnectorConfig(MapValue<String, Object> clientEndpointConfig, WebSocketClientConnectorConfig clientConnectorConfig, String scheme) {
        long idleTimeoutInSeconds;
        clientConnectorConfig.setAutoRead(false);
        clientConnectorConfig.setSubProtocols(WebSocketUtil.findNegotiableSubProtocols(clientEndpointConfig));
        MapValue headerValues = clientEndpointConfig.getMapValue("customHeaders");
        if (headerValues != null) {
            clientConnectorConfig.addHeaders(WebSocketUtil.getCustomHeaders((MapValue<String, Object>)headerValues));
        }
        if ((idleTimeoutInSeconds = (long)WebSocketUtil.findTimeoutInSeconds(clientEndpointConfig, "idleTimeoutInSeconds", 0)) > 0L) {
            clientConnectorConfig.setIdleTimeoutInMillis((int)(idleTimeoutInSeconds * 1000L));
        }
        clientConnectorConfig.setMaxFrameSize(WebSocketUtil.findMaxFrameSize(clientEndpointConfig));
        MapValue secureSocket = clientEndpointConfig.getMapValue("secureSocket");
        if (secureSocket != null) {
            HttpUtil.populateSSLConfiguration((SslConfiguration)clientConnectorConfig, secureSocket);
        } else if (scheme.equals("wss")) {
            clientConnectorConfig.useJavaDefaults();
        }
        clientConnectorConfig.setWebSocketCompressionEnabled(clientEndpointConfig.getBooleanValue("webSocketCompressionEnabled").booleanValue());
    }

    private static Map<String, String> getCustomHeaders(MapValue<String, Object> headers) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        headers.entrySet().forEach(entry -> customHeaders.put((String)entry.getKey(), headers.get(entry.getKey()).toString()));
        return customHeaders;
    }

    public static void waitForHandshake(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WebSocketException(ERROR_MESSAGE + e.getMessage());
        }
    }

    private static WebSocketClientConnector createWebSocketClientConnector(String remoteUrl, ObjectValue webSocketClient) {
        MapValue clientEndpointConfig = webSocketClient.getMapValue(CLIENT_ENDPOINT_CONFIG);
        WebSocketClientConnectorConfig clientConnectorConfig = new WebSocketClientConnectorConfig(remoteUrl);
        WebSocketUtil.populateClientConnectorConfig((MapValue<String, Object>)clientEndpointConfig, clientConnectorConfig, remoteUrl);
        HttpWsConnectorFactory connectorFactory = (HttpWsConnectorFactory)webSocketClient.getNativeData("connectorFactory");
        return connectorFactory.createWsClientConnector(clientConnectorConfig);
    }

    public static WebSocketService validateAndCreateWebSocketService(Strand strand, MapValue<String, Object> clientEndpointConfig) {
        Object clientService = clientEndpointConfig.get((Object)"callbackService");
        if (clientService != null) {
            BType param = ((ObjectValue)clientService).getType().getAttachedFunctions()[0].getParameterType()[0];
            if (param == null || !"http:WebSocketClient".equals(param.toString()) && !WEBSOCKET_FAILOVER_CLIENT_NAME.equals(param.toString())) {
                throw new WebSocketException("The callback service should be a WebSocket Client Service");
            }
            return new WebSocketService((ObjectValue)clientService, strand.scheduler);
        }
        return new WebSocketService(strand.scheduler);
    }

    public static void countDownForHandshake(ObjectValue webSocketClient) {
        if (webSocketClient.getNativeData("countDownLatch") != null) {
            ((CountDownLatch)webSocketClient.getNativeData("countDownLatch")).countDown();
            webSocketClient.addNativeData("countDownLatch", null);
        }
    }

    private WebSocketUtil() {
    }
}

