/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.FailoverContext;
import org.ballerinalang.net.http.websocket.client.InitEndpoint;
import org.ballerinalang.net.http.websocket.client.listener.ClientConnectorListener;
import org.ballerinalang.net.http.websocket.client.listener.FailoverConnectorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverInitEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(FailoverInitEndpoint.class);
    private static final String FAILOVER_INTERVAL = "failoverIntervalInMillis";

    public static void initEndpoint(ObjectValue failoverClient) {
        MapValue clientEndpointConfig = failoverClient.getMapValue("config");
        List<String> newTargetUrls = FailoverInitEndpoint.getValidUrls(clientEndpointConfig.getArrayValue("targetUrls"));
        failoverClient.set("url", (Object)newTargetUrls.get(0));
        FailoverContext failoverContext = new FailoverContext();
        FailoverInitEndpoint.populateFailoverContext((MapValue<String, Object>)clientEndpointConfig, failoverContext, newTargetUrls);
        failoverClient.addNativeData("failoverContext", (Object)failoverContext);
        failoverClient.addNativeData("clientListener", (Object)new FailoverConnectorListener(new ClientConnectorListener()));
        InitEndpoint.initEndpoint(failoverClient);
    }

    private static void populateFailoverContext(MapValue<String, Object> failoverConfig, FailoverContext failoverClientConnectorConfig, List<String> targetUrls) {
        failoverClientConnectorConfig.setFailoverInterval(WebSocketUtil.getIntValue(failoverConfig, FAILOVER_INTERVAL, 1000));
        failoverClientConnectorConfig.setTargetUrls(targetUrls);
    }

    private static List<String> getValidUrls(ArrayValue targets) {
        ArrayList<String> newTargetUrls = new ArrayList<String>();
        int index = 0;
        for (int i = 0; i < targets.size(); ++i) {
            String url = targets.get((long)i).toString();
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                    String name = targets.get((long)i).toString();
                    logger.error("{} drop from the targets url because webSocket client supports only WS(S) scheme.", (Object)name);
                    continue;
                }
                newTargetUrls.add(index, url);
                ++index;
                continue;
            }
            catch (URISyntaxException e) {
                logger.error("Error occurred when constructing a hierarchical URI from the given url[" + url + "].");
            }
        }
        if (newTargetUrls.isEmpty()) {
            throw new WebSocketException("TargetUrls should have at least one valid URL.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("New targetUrls: {}", newTargetUrls);
        }
        return newTargetUrls;
    }

    private FailoverInitEndpoint() {
    }
}

