/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.client;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.websocket.WebSocketService;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.client.listener.ClientConnectorListener;
import org.wso2.transport.http.netty.contract.HttpWsConnectorFactory;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnector;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnectorConfig;

public class InitEndpoint {
    public static void initEndpoint(ObjectValue webSocketClient) {
        MapValue clientEndpointConfig = webSocketClient.getMapValue("config");
        Strand strand = Scheduler.getStrand();
        String remoteUrl = webSocketClient.getStringValue("url");
        WebSocketService wsService = WebSocketUtil.validateAndCreateWebSocketService(strand, (MapValue<String, Object>)clientEndpointConfig);
        HttpWsConnectorFactory connectorFactory = HttpUtil.createHttpWsConnectionFactory();
        WebSocketClientConnectorConfig clientConnectorConfig = new WebSocketClientConnectorConfig(remoteUrl);
        String scheme = URI.create(remoteUrl).getScheme();
        WebSocketUtil.populateClientConnectorConfig((MapValue<String, Object>)clientEndpointConfig, clientConnectorConfig, scheme);
        WebSocketClientConnector clientConnector = connectorFactory.createWsClientConnector(clientConnectorConfig);
        webSocketClient.addNativeData("connectorFactory", (Object)connectorFactory);
        webSocketClient.addNativeData("clientConnector", (Object)clientConnector);
        if (webSocketClient.getNativeData("clientListener") == null) {
            webSocketClient.addNativeData("clientListener", (Object)new ClientConnectorListener());
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        webSocketClient.addNativeData("countDownLatch", (Object)countDownLatch);
        WebSocketUtil.establishWebSocketConnection(clientConnector, webSocketClient, wsService);
        WebSocketUtil.waitForHandshake(countDownLatch);
    }

    private InitEndpoint() {
    }
}

