/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.observability;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.observability.metrics.Tags;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;

public class WebSocketObserverContext
extends ObserverContext {
    private String connectionId = "unknown";
    private String servicePathOrClientUrl = "unknown";

    WebSocketObserverContext() {
        this.setConnectorName("ws");
    }

    public WebSocketObserverContext(WebSocketConnectionInfo connectionInfo) {
        this();
        this.connectionId = WebSocketObservabilityUtil.getConnectionId(connectionInfo);
        this.servicePathOrClientUrl = WebSocketObservabilityUtil.getServicePathOrClientUrl(connectionInfo);
        this.setTags(connectionInfo);
    }

    public void setTags(WebSocketConnectionInfo connectionInfo) {
        this.addTag("client_or_server", WebSocketObservabilityUtil.getClientOrServerContext(connectionInfo));
        this.addTag("service", this.servicePathOrClientUrl);
    }

    String getConnectionId() {
        return this.connectionId;
    }

    String getServicePathOrClientUrl() {
        return this.servicePathOrClientUrl;
    }

    Set<Tag> getAllTags() {
        Map tags = this.getTags();
        HashSet<Tag> allTags = new HashSet<Tag>(tags.size());
        Tags.tags(allTags, (Map)tags);
        return allTags;
    }
}

