/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.server;

import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.server.UpgradeListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionManager;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;

public class OnUpgradeResourceCallback
implements CallableUnitCallback {
    private final WebSocketHandshaker webSocketHandshaker;
    private final WebSocketServerService wsService;
    private final WebSocketConnectionManager connectionManager;

    public OnUpgradeResourceCallback(WebSocketHandshaker webSocketHandshaker, WebSocketServerService wsService, WebSocketConnectionManager connectionManager) {
        this.webSocketHandshaker = webSocketHandshaker;
        this.wsService = wsService;
        this.connectionManager = connectionManager;
    }

    public void notifySuccess() {
        if (!this.webSocketHandshaker.isCancelled() && !this.webSocketHandshaker.isHandshakeStarted()) {
            ServerHandshakeFuture future = this.webSocketHandshaker.handshake(this.wsService.getNegotiableSubProtocols(), this.wsService.getIdleTimeoutInSeconds() * 1000, null, this.wsService.getMaxFrameSize());
            future.setHandshakeListener((ServerHandshakeListener)new UpgradeListener(this.wsService, this.connectionManager));
        } else if (!this.webSocketHandshaker.isCancelled()) {
            WebSocketConnectionInfo connectionInfo = this.connectionManager.getConnectionInfo(this.webSocketHandshaker.getChannelId());
            WebSocketConnection webSocketConnection = null;
            try {
                webSocketConnection = connectionInfo.getWebSocketConnection();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            WebSocketResourceDispatcher.dispatchOnOpen(webSocketConnection, connectionInfo.getWebSocketEndpoint(), this.wsService);
        }
    }

    public void notifyFailure(ErrorValue error) {
        ErrorHandlerUtils.printError((String)error.getPrintableStackTrace());
        WebSocketConnectionInfo connectionInfo = this.connectionManager.getConnectionInfo(this.webSocketHandshaker.getChannelId());
        if (connectionInfo != null) {
            try {
                WebSocketUtil.closeDuringUnexpectedCondition(connectionInfo.getWebSocketConnection());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

