/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.server;

import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.http.websocket.WebSocketConstants;
import org.ballerinalang.net.http.websocket.WebSocketException;
import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionManager;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;

class UpgradeListener
implements ServerHandshakeListener {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeListener.class);
    private final WebSocketServerService wsService;
    private final WebSocketConnectionManager connectionManager;

    UpgradeListener(WebSocketServerService wsService, WebSocketConnectionManager connectionManager) {
        this.wsService = wsService;
        this.connectionManager = connectionManager;
    }

    public void onSuccess(WebSocketConnection webSocketConnection) {
        ObjectValue webSocketCaller = WebSocketUtil.createAndPopulateWebSocketCaller(webSocketConnection, this.wsService, this.connectionManager);
        WebSocketResourceDispatcher.dispatchOnOpen(webSocketConnection, webSocketCaller, this.wsService);
    }

    public void onError(Throwable throwable) {
        String msg = "Unable to complete WebSocket handshake: ";
        logger.error(msg, throwable);
        throw new WebSocketException(WebSocketConstants.ErrorCode.WsInvalidHandshakeError, msg + throwable.getMessage());
    }
}

