/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.http.websocket.server;

import java.net.URI;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.net.http.HttpResource;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.http.HttpUtil;
import org.ballerinalang.net.http.websocket.WebSocketResourceDispatcher;
import org.ballerinalang.net.http.websocket.WebSocketUtil;
import org.ballerinalang.net.http.websocket.observability.WebSocketObservabilityUtil;
import org.ballerinalang.net.http.websocket.server.UpgradeListener;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionInfo;
import org.ballerinalang.net.http.websocket.server.WebSocketConnectionManager;
import org.ballerinalang.net.http.websocket.server.WebSocketServerService;
import org.ballerinalang.net.http.websocket.server.WebSocketServicesRegistry;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketBinaryMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketCloseMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contract.websocket.WebSocketControlMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contract.websocket.WebSocketMessage;
import org.wso2.transport.http.netty.contract.websocket.WebSocketTextMessage;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class WebSocketServerListener
implements WebSocketConnectorListener {
    private final WebSocketServicesRegistry servicesRegistry;
    private final WebSocketConnectionManager connectionManager;
    private final MapValue httpEndpointConfig;

    public WebSocketServerListener(WebSocketServicesRegistry servicesRegistry, MapValue httpEndpointConfig) {
        this.servicesRegistry = servicesRegistry;
        this.connectionManager = new WebSocketConnectionManager();
        this.httpEndpointConfig = httpEndpointConfig;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
        HttpResourceArguments pathParams = new HttpResourceArguments();
        URI requestUri = this.createRequestUri(webSocketHandshaker);
        WebSocketServerService wsService = this.servicesRegistry.findMatching(requestUri.getPath(), pathParams, webSocketHandshaker);
        if (wsService == null) {
            String errMsg = "No service found to handle the service request";
            webSocketHandshaker.cancelHandshake(404, errMsg);
            WebSocketObservabilityUtil.observeError("connection", errMsg, requestUri.getPath(), "server");
            return;
        }
        this.setCarbonMessageProperties(pathParams, requestUri, (HttpCarbonMessage)webSocketHandshaker.getHttpCarbonRequest());
        HttpResource onUpgradeResource = wsService.getUpgradeResource();
        if (onUpgradeResource != null) {
            WebSocketResourceDispatcher.dispatchUpgrade(webSocketHandshaker, wsService, this.httpEndpointConfig, this.connectionManager);
        } else {
            ServerHandshakeFuture future = webSocketHandshaker.handshake(wsService.getNegotiableSubProtocols(), wsService.getIdleTimeoutInSeconds() * 1000, null, wsService.getMaxFrameSize());
            future.setHandshakeListener((ServerHandshakeListener)new UpgradeListener(wsService, this.connectionManager));
        }
    }

    private URI createRequestUri(WebSocketHandshaker webSocketHandshaker) {
        String serviceUri = webSocketHandshaker.getTarget();
        serviceUri = HttpUtil.sanitizeBasePath(serviceUri);
        return URI.create(serviceUri);
    }

    private void setCarbonMessageProperties(HttpResourceArguments pathParams, URI requestUri, HttpCarbonMessage msg) {
        msg.setProperty("QUERY_STR", (Object)requestUri.getRawQuery());
        msg.setProperty("RAW_QUERY_STR", (Object)requestUri.getRawQuery());
        msg.setProperty("RESOURCE_ARGS", (Object)pathParams);
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        WebSocketResourceDispatcher.dispatchOnText(this.getConnectionInfo((WebSocketMessage)webSocketTextMessage), webSocketTextMessage);
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        WebSocketResourceDispatcher.dispatchOnBinary(this.getConnectionInfo((WebSocketMessage)webSocketBinaryMessage), webSocketBinaryMessage);
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        WebSocketResourceDispatcher.dispatchOnPingOnPong(this.getConnectionInfo((WebSocketMessage)webSocketControlMessage), webSocketControlMessage);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        WebSocketResourceDispatcher.dispatchOnClose(this.getConnectionInfo((WebSocketMessage)webSocketCloseMessage), webSocketCloseMessage);
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        WebSocketObservabilityUtil.observeClose(this.getConnectionInfo(webSocketConnection));
        try {
            WebSocketUtil.setListenerOpenField(this.connectionManager.removeConnectionInfo(webSocketConnection.getChannelId()));
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        WebSocketResourceDispatcher.dispatchOnError(this.getConnectionInfo(webSocketConnection), throwable);
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        WebSocketResourceDispatcher.dispatchOnIdleTimeout(this.getConnectionInfo((WebSocketMessage)controlMessage));
    }

    private String getConnectionId(WebSocketMessage webSocketMessage) {
        return webSocketMessage.getWebSocketConnection().getChannelId();
    }

    private WebSocketConnectionInfo getConnectionInfo(WebSocketMessage webSocketMessage) {
        return this.connectionManager.getConnectionInfo(this.getConnectionId(webSocketMessage));
    }

    private WebSocketConnectionInfo getConnectionInfo(WebSocketConnection webSocketConnection) {
        return this.connectionManager.getConnectionInfo(webSocketConnection.getChannelId());
    }
}

