/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.uri.parser;

import java.util.Map;
import org.ballerinalang.net.http.HttpResourceArguments;
import org.ballerinalang.net.uri.URITemplateException;
import org.ballerinalang.net.uri.parser.DataElement;
import org.ballerinalang.net.uri.parser.Expression;
import org.ballerinalang.net.uri.parser.Variable;

public class SimpleStringExpression<DataType, InboundMsgType>
extends Expression<DataType, InboundMsgType> {
    private static final char[] RESERVED = new char[]{':', '/', '?', '#', '[', ']', '@', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='};

    SimpleStringExpression(DataElement<DataType, InboundMsgType> dataElement, String token) throws URITemplateException {
        super(dataElement, token);
    }

    @Override
    String expand(Map<String, String> variables) {
        boolean emptyString = false;
        StringBuilder buffer = new StringBuilder();
        for (Variable var : this.variableList) {
            String value;
            String name = var.getName();
            if (!variables.containsKey(name)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.getSeparator());
            }
            if ("".equals(value = var.modify(variables.get(name)))) {
                emptyString = true;
            }
            buffer.append(this.encodeValue(value));
        }
        if (buffer.length() == 0 && !emptyString) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    int match(String uriFragment, HttpResourceArguments variables) {
        int length = uriFragment.length();
        for (int i = 0; i < length; ++i) {
            char ch = uriFragment.charAt(i);
            if (this.isEndCharacter(Character.valueOf(ch))) {
                if (ch == this.getSeparator() && this.variableList.size() > 0) continue;
                if (!this.setVariables(uriFragment.substring(0, i), variables)) {
                    return -1;
                }
                return i;
            }
            if (i != length - 1) continue;
            if (!this.setVariables(uriFragment, variables)) {
                return -1;
            }
            return length;
        }
        return 0;
    }

    @Override
    char getFirstCharacter() {
        return '\u0001';
    }

    protected boolean isEndCharacter(Character endCharacter) {
        return endCharacter.charValue() == '/';
    }

    private char getSeparator() {
        return ',';
    }

    boolean setVariables(String expressionValue, HttpResourceArguments variables) {
        String finalValue = this.decodeValue(expressionValue);
        for (Variable var : this.variableList) {
            String name = var.getName();
            if (variables.getMap().containsKey(name) && !finalValue.equals(variables.getMap().get(name))) {
                return false;
            }
            if (var.checkModifier(finalValue)) {
                variables.getMap().put(name, finalValue);
                continue;
            }
            return false;
        }
        return true;
    }

    protected boolean isReserved(char ch) {
        for (char reservedChar : RESERVED) {
            if (ch != reservedChar) continue;
            return true;
        }
        return false;
    }
}

