/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTable {
    private static final Logger log = LoggerFactory.getLogger(GetTable.class);
    private static final String CSV_CHANNEL_DELIMITED_STRUCT_FIELD = "dc";

    private GetTable() {
    }

    public static Object getTable(BObject csvChannel, BTypedesc bTypedesc, BArray key) {
        try {
            BObject delimitedObj = (BObject)csvChannel.get(StringUtils.fromString((String)CSV_CHANNEL_DELIMITED_STRUCT_FIELD));
            DelimitedRecordChannel delimitedChannel = (DelimitedRecordChannel)delimitedObj.getNativeData("txt_record");
            if (delimitedChannel.hasReachedEnd()) {
                return IOUtils.createEoFError();
            }
            ArrayList<String[]> records = new ArrayList<String[]>();
            while (delimitedChannel.hasNext()) {
                records.add(delimitedChannel.read());
            }
            return GetTable.getTable(bTypedesc, key, records);
        }
        catch (BError | BallerinaIOException e) {
            String msg = "failed to process the delimited file: " + e.getMessage();
            return IOUtils.createError(msg);
        }
    }

    private static BTable getTable(BTypedesc bTypedesc, BArray key, List<String[]> records) {
        Type describingType = bTypedesc.getDescribingType();
        TableType newTableType = key.size() == 0 ? TypeCreator.createTableType((Type)describingType, (boolean)false) : TypeCreator.createTableType((Type)describingType, (String[])key.getStringArray(), (boolean)false);
        BTable table = ValueCreator.createTableValue((TableType)newTableType);
        StructureType structType = (StructureType)describingType;
        for (String[] fields : records) {
            Map<String, Object> struct = GetTable.getStruct(fields, structType);
            if (struct == null) continue;
            table.add((Object)ValueCreator.createRecordValue((Module)describingType.getPackage(), (String)describingType.getName(), struct));
        }
        return table;
    }

    private static Map<String, Object> getStruct(String[] fields, StructureType structType) {
        Map internalStructFields = structType.getFields();
        int fieldLength = internalStructFields.size();
        HashMap<String, Object> struct = null;
        if (fields.length > 0) {
            Iterator itr = internalStructFields.entrySet().iterator();
            struct = new HashMap<String, Object>();
            for (int i = 0; i < fieldLength; ++i) {
                Field internalStructField = (Field)itr.next().getValue();
                int type = internalStructField.getFieldType().getTag();
                String fieldName = internalStructField.getFieldName();
                if (fields.length > i) {
                    String value = fields[i];
                    switch (type) {
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: {
                            GetTable.populateRecord(type, struct, fieldName, value);
                            break;
                        }
                        case 21: {
                            List members = ((UnionType)internalStructField.getFieldType()).getMemberTypes();
                            if (((Type)members.get(0)).getTag() == 10) {
                                GetTable.populateRecord(((Type)members.get(1)).getTag(), struct, fieldName, value);
                                break;
                            }
                            if (((Type)members.get(1)).getTag() == 10) {
                                GetTable.populateRecord(((Type)members.get(0)).getTag(), struct, fieldName, value);
                                break;
                            }
                            throw IOUtils.createError("unsupported nillable field for value: " + value);
                        }
                        default: {
                            throw IOUtils.createError("type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
                        }
                    }
                    continue;
                }
                struct.put(fieldName, null);
            }
        }
        return struct;
    }

    private static void populateRecord(int type, Map<String, Object> struct, String fieldName, String value) {
        switch (type) {
            case 1: {
                struct.put(fieldName, value == null || value.isEmpty() ? null : Long.valueOf(Long.parseLong(value)));
                return;
            }
            case 3: {
                struct.put(fieldName, value == null || value.isEmpty() ? null : Double.valueOf(Double.parseDouble(value)));
                break;
            }
            case 5: {
                struct.put(fieldName, value);
                break;
            }
            case 6: {
                struct.put(fieldName, value == null || value.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(value)));
                break;
            }
            default: {
                throw IOUtils.createError("type casting support only for int, float, boolean and string. Invalid value for the struct field: " + value);
            }
        }
    }
}

